/*
 * Decompiled with CFR 0.152.
 */
package org.update4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.module.ModuleFinder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.update4j.Configuration;
import org.update4j.FileMetadata;
import org.update4j.OS;
import org.update4j.mapper.FileMapper;
import org.update4j.mapper.MapMapper;
import org.update4j.util.FileUtils;

public class Archive {
    private Path location;
    private Configuration config;
    private List<FileMetadata> files;
    static final String RESERVED_DIR = "reserved";
    static final String CONFIG_PATH = "config";
    static final String DYNAMIC_PATH = "dynamic";
    static final String FILES_DIR = "files";
    static final String DYNAMIC_NODE = "dynamic-properties";

    public static Archive read(Path location) throws IOException {
        Archive archive = new Archive(location);
        archive.load();
        return archive;
    }

    public static Archive read(String location) throws IOException {
        return Archive.read(Paths.get(location, new String[0]));
    }

    Archive(Path location) {
        this.location = location;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private void load() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileSystem zip = this.openConnection();){
            BufferedReader in;
            Iterator<FileMetadata> iterator;
            Throwable throwable2;
            Path filesPath = zip.getPath(FILES_DIR, new String[0]);
            Path reservedPath = zip.getPath(RESERVED_DIR, new String[0]);
            Path configPath = reservedPath.resolve(CONFIG_PATH);
            Path dynamicPath = configPath.resolveSibling(DYNAMIC_PATH);
            if (Files.notExists(configPath, new LinkOption[0])) {
                throw new NoSuchFileException(configPath.toString(), null, "Configuration file is missing");
            }
            Map<String, String> dynamicProperties = null;
            if (Files.exists(dynamicPath, new LinkOption[0])) {
                throwable2 = null;
                iterator = null;
                try {
                    in = Files.newBufferedReader(dynamicPath);
                    try {
                        dynamicProperties = MapMapper.read(in, DYNAMIC_NODE);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            throwable2 = null;
            iterator = null;
            try {
                in = Files.newBufferedReader(configPath);
                try {
                    this.config = Configuration.read((Reader)in, dynamicProperties);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            throwable2 = null;
            iterator = null;
            try (Stream<Path> stream = Files.walk(filesPath, new FileVisitOption[0]);){
                this.files = stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(Archive::toRelativeFileString).map(p -> this.getConfiguration().getFiles().stream().filter(file -> file.getNormalizedPath().toString().replace("\\", "/").equals(p.toString())).findAny().orElseThrow(() -> new IllegalStateException(String.valueOf(p) + ": Archive entry cannot be linked to a file in the configuration"))).collect(Collectors.toList());
                this.files = Collections.unmodifiableList(this.files);
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
            for (FileMetadata file : this.getFiles()) {
                Path p2 = FileUtils.resolve(filesPath, file.getNormalizedPath());
                if (FileMapper.getChecksum(p2) == file.getChecksum()) continue;
                throw new IOException(p2 + ": File has been tampered with");
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public List<FileMetadata> getFiles() {
        return this.files;
    }

    public Path getLocation() {
        return this.location;
    }

    public void install(boolean deleteArchive) throws IOException {
        FileUtils.verifyAccessible(this.getLocation());
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileSystem zip = this.openConnection();){
            Path filesPath = zip.getPath(FILES_DIR, new String[0]);
            HashMap<Path, Path> files = new HashMap<Path, Path>();
            for (FileMetadata fileMetadata : this.getFiles()) {
                Path path = FileUtils.resolve(filesPath, fileMetadata.getNormalizedPath());
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    throw new IOException(path + ": File is missing or invalid");
                }
                FileUtils.verifyAccessible(fileMetadata.getPath());
                files.put(path, fileMetadata.getNormalizedPath());
            }
            for (Map.Entry entry : files.entrySet()) {
                if (((Path)entry.getValue()).getParent() != null) {
                    Files.createDirectories(((Path)entry.getValue()).getParent(), new FileAttribute[0]);
                }
                FileUtils.secureMoveFile((Path)entry.getKey(), (Path)entry.getValue());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (deleteArchive) {
            Files.deleteIfExists(this.getLocation());
        }
    }

    public void install() throws IOException {
        this.install(true);
    }

    public FileSystem openConnection() throws IOException {
        if (Files.notExists(this.getLocation(), new LinkOption[0])) {
            Throwable throwable = null;
            Object var2_4 = null;
            try (OutputStream out = Files.newOutputStream(this.getLocation(), StandardOpenOption.CREATE_NEW);){
                byte[] byArray = new byte[22];
                byArray[0] = 80;
                byArray[1] = 75;
                byArray[2] = 5;
                byArray[3] = 6;
                out.write(byArray);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        try {
            return FileSystems.newFileSystem(this.getLocation(), null);
        }
        catch (ProviderNotFoundException e) {
            ModuleFinder.ofSystem().find("jdk.zipfs").orElseThrow(() -> new ProviderNotFoundException("Accessing the archive depends on the jdk.zipfs module which is missing from the JRE image"));
            throw e;
        }
    }

    private static String toRelativeFileString(Path path) {
        String str = path.toString();
        String pattern = "^(:?\\\\|/)?files";
        if (OS.CURRENT == OS.WINDOWS) {
            pattern = String.valueOf(pattern) + "(:?\\\\|/)";
        }
        return str.replaceFirst(pattern, "");
    }
}

