/*
 * Decompiled with CFR 0.152.
 */
package org.update4j;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.update4j.inject.Injectable;
import org.update4j.service.Delegate;
import org.update4j.service.Service;

public class Bootstrap {
    public static final String VERSION = "1.5.9";

    private Bootstrap() {
    }

    public static void main(String[] args) throws Throwable {
        String classname = null;
        List<String> argsList = List.of(args);
        if (args.length > 0) {
            String firstArg = args[0].trim();
            if (firstArg.equals("--delegate")) {
                if (args.length == 1) {
                    throw new IllegalArgumentException("Missing class name for delegate option.");
                }
                classname = args[1].trim();
                argsList = argsList.subList(2, argsList.size());
            } else if (firstArg.matches("--delegate(?:\\s*=\\s*|\\s+)")) {
                Pattern pattern = Pattern.compile("--delegate(?:\\s*=\\s*|\\s+)(.+)");
                Matcher match = pattern.matcher(firstArg);
                if (!match.find()) {
                    throw new IllegalArgumentException("Missing class name for delegate option.");
                }
                classname = match.group(1);
                argsList = argsList.subList(1, argsList.size());
            }
        }
        Bootstrap.start(classname, argsList);
    }

    public static void start() throws Throwable {
        Bootstrap.start(null);
    }

    public static void start(Injectable injectable) throws Throwable {
        Bootstrap.start(null, null, injectable);
    }

    public static void start(String classname) throws Throwable {
        Bootstrap.start(classname, null, null);
    }

    public static void start(String classname, List<String> args) throws Throwable {
        Bootstrap.start(classname, args, null);
    }

    public static void start(String classname, Injectable injectable) throws Throwable {
        Bootstrap.start(classname, null, injectable);
    }

    public static void start(Delegate delegate) throws Throwable {
        Bootstrap.start(delegate, null);
    }

    public static void start(List<String> args) throws Throwable {
        Bootstrap.start(args, null);
    }

    public static void start(List<String> args, Injectable injectable) throws Throwable {
        Bootstrap.start(null, args, injectable);
    }

    public static void start(String classname, List<String> args, Injectable injectable) throws Throwable {
        Delegate delegate = Service.loadService(Delegate.class, classname);
        if (injectable != null) {
            Injectable.injectBidirectional(injectable, delegate);
        }
        Bootstrap.start(delegate, args);
    }

    public static void start(Delegate delegate, List<String> args) throws Throwable {
        args = args == null ? List.of() : args;
        delegate.main(args);
    }
}

