/*
 * Decompiled with CFR 0.152.
 */
package org.update4j;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.module.FindException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.update4j.AddPackage;
import org.update4j.Archive;
import org.update4j.Configuration;
import org.update4j.DynamicClassLoader;
import org.update4j.FileMetadata;
import org.update4j.LaunchContext;
import org.update4j.OS;
import org.update4j.Update;
import org.update4j.UpdateContext;
import org.update4j.UpdateOptions;
import org.update4j.UpdateResult;
import org.update4j.inject.Injectable;
import org.update4j.inject.UnsatisfiedInjectionException;
import org.update4j.mapper.MapMapper;
import org.update4j.service.Launcher;
import org.update4j.service.Service;
import org.update4j.service.UpdateHandler;
import org.update4j.util.FileUtils;
import org.update4j.util.ModuleUtils;
import org.update4j.util.StringUtils;
import org.update4j.util.Warning;

class ConfigImpl {
    private ConfigImpl() {
    }

    @Deprecated
    static boolean doLegacyUpdate(Configuration config, Path tempDir, PublicKey key, Injectable injectable, UpdateHandler handler) {
        boolean success;
        block41: {
            boolean updateTemp = tempDir != null;
            boolean doneDownloads = false;
            if (handler == null) {
                handler = Service.loadService(UpdateHandler.class, config.getUpdateHandler());
            }
            if (injectable != null) {
                try {
                    Injectable.injectBidirectional(injectable, handler);
                }
                catch (IllegalAccessException | InvocationTargetException | UnsatisfiedInjectionException e) {
                    throw new RuntimeException(e);
                }
            }
            HashMap<FileMetadata, Path> downloadedCollection = new HashMap<FileMetadata, Path>();
            try {
                ArrayList<FileMetadata> requiresUpdate = new ArrayList<FileMetadata>();
                ArrayList<FileMetadata> updated = new ArrayList<FileMetadata>();
                UpdateContext ctx = new UpdateContext(config, requiresUpdate, updated, tempDir, key, null);
                handler.init(ctx);
                handler.startCheckUpdates();
                handler.updateCheckUpdatesProgress(0.0f);
                List osFiles = config.getFiles().stream().filter(file -> file.getOs() == null || file.getOs() == OS.CURRENT).collect(Collectors.toList());
                long updateJobSize = osFiles.stream().mapToLong(FileMetadata::getSize).sum();
                double updateJobCompleted = 0.0;
                for (FileMetadata file2 : osFiles) {
                    if (handler.shouldCheckForUpdate(file2)) {
                        handler.startCheckUpdateFile(file2);
                        boolean needsUpdate = file2.requiresUpdate();
                        if (needsUpdate) {
                            requiresUpdate.add(file2);
                        }
                        handler.doneCheckUpdateFile(file2, needsUpdate);
                    }
                    handler.updateCheckUpdatesProgress(ConfigImpl.clamp((float)((updateJobCompleted += (double)file2.getSize()) / (double)updateJobSize)));
                }
                handler.doneCheckUpdates();
                Signature sig = null;
                if (key != null) {
                    sig = FileUtils.getSignature(key);
                    sig.initVerify(key);
                }
                long downloadJobSize = requiresUpdate.stream().mapToLong(FileMetadata::getSize).sum();
                double downloadJobCompleted = 0.0;
                if (!requiresUpdate.isEmpty()) {
                    if (key == null && config.getSignature() != null) {
                        Warning.signature();
                    }
                    handler.startDownloads();
                    for (FileMetadata file3 : requiresUpdate) {
                        Path output;
                        handler.startDownloadFile(file3);
                        int read = 0;
                        double currentCompleted = 0.0;
                        byte[] buffer = new byte[8192];
                        if (!updateTemp) {
                            Files.createDirectories(file3.getNormalizedPath().getParent(), new FileAttribute[0]);
                            output = Files.createTempFile(file3.getNormalizedPath().getParent(), null, null, new FileAttribute[0]);
                        } else {
                            Files.createDirectories(tempDir, new FileAttribute[0]);
                            output = Files.createTempFile(tempDir, null, null, new FileAttribute[0]);
                        }
                        downloadedCollection.put(file3, output);
                        Throwable throwable = null;
                        Object var30_32 = null;
                        try {
                            InputStream in = handler.openDownloadStream(file3);
                            try {
                                try (OutputStream out = Files.newOutputStream(output, new OpenOption[0]);){
                                    if (downloadJobCompleted == 0.0) {
                                        handler.updateDownloadProgress(0.0f);
                                    }
                                    handler.updateDownloadFileProgress(file3, 0.0f);
                                    while ((read = in.read(buffer, 0, buffer.length)) > -1) {
                                        out.write(buffer, 0, read);
                                        if (sig != null) {
                                            sig.update(buffer, 0, read);
                                        }
                                        handler.updateDownloadFileProgress(file3, ConfigImpl.clamp((float)((currentCompleted += (double)read) / (double)file3.getSize())));
                                        handler.updateDownloadProgress(ConfigImpl.clamp((float)(downloadJobCompleted += (double)read) / (float)downloadJobSize));
                                    }
                                    handler.validatingFile(file3, output);
                                    ConfigImpl.validateFile(file3, output, sig);
                                    updated.add(file3);
                                    handler.doneDownloadFile(file3, output);
                                }
                                if (in == null) continue;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (in != null) {
                                    in.close();
                                }
                                throw throwable;
                            }
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    ConfigImpl.completeDownloads(downloadedCollection, tempDir, updateTemp);
                    doneDownloads = true;
                    handler.doneDownloads();
                }
                success = true;
                break block41;
            }
            catch (Throwable t) {
                try {
                    if (!(!updateTemp && doneDownloads || downloadedCollection.isEmpty())) {
                        for (Path p : downloadedCollection.values()) {
                            Files.deleteIfExists(p);
                        }
                        if (updateTemp) {
                            Files.deleteIfExists(tempDir.resolve(Update.UPDATE_DATA));
                            if (FileUtils.isEmptyDirectory(tempDir)) {
                                Files.deleteIfExists(tempDir);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Warning.lock(t);
            success = false;
            handler.failed(t);
        }
        if (success) {
            handler.succeeded();
        }
        handler.stop();
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static UpdateResult doUpdate(Configuration config, UpdateOptions.ArchiveUpdateOptions options) {
        boolean success;
        PublicKey key = options.getPublicKey();
        Throwable exception = null;
        boolean doneDownloads = false;
        UpdateHandler handler = options.getUpdateHandler();
        if (handler == null) {
            handler = Service.loadService(UpdateHandler.class, config.getUpdateHandler());
        }
        if (options.getInjectable() != null) {
            try {
                Injectable.injectBidirectional(options.getInjectable(), handler);
            }
            catch (IllegalAccessException | InvocationTargetException | UnsatisfiedInjectionException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            block55: {
                ArrayList<FileMetadata> requiresUpdate = new ArrayList<FileMetadata>();
                ArrayList<FileMetadata> updated = new ArrayList<FileMetadata>();
                UpdateContext ctx = new UpdateContext(config, requiresUpdate, updated, null, options.getPublicKey(), options.getArchiveLocation());
                handler.init(ctx);
                handler.startCheckUpdates();
                handler.updateCheckUpdatesProgress(0.0f);
                List osFiles = config.getFiles().stream().filter(file -> file.getOs() == null || file.getOs() == OS.CURRENT).collect(Collectors.toList());
                long updateJobSize = osFiles.stream().mapToLong(FileMetadata::getSize).sum();
                double updateJobCompleted = 0.0;
                Iterator iterator = osFiles.iterator();
                block28: while (true) {
                    if (!iterator.hasNext()) {
                        handler.doneCheckUpdates();
                        Signature sig = null;
                        if (key != null) {
                            sig = FileUtils.getSignature(key);
                            sig.initVerify(key);
                        }
                        long downloadJobSize = requiresUpdate.stream().mapToLong(FileMetadata::getSize).sum();
                        double downloadJobCompleted = 0.0;
                        if (requiresUpdate.isEmpty()) break block55;
                        if (key == null && config.getSignature() != null) {
                            Warning.signature();
                        }
                        Archive archive = new Archive(options.getArchiveLocation());
                        Throwable throwable = null;
                        Object var22_23 = null;
                        try (FileSystem zip = archive.openConnection();){
                            BufferedWriter out22;
                            Path configPath = zip.getPath("reserved", "config");
                            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                            Throwable throwable2 = null;
                            Object object = null;
                            try {
                                out22 = Files.newBufferedWriter(configPath, new OpenOption[0]);
                                try {
                                    config.write(out22);
                                }
                                finally {
                                    if (out22 != null) {
                                        out22.close();
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                                throw throwable2;
                            }
                            if (!config.getDynamicProperties().isEmpty()) {
                                Path dynamicPath = zip.getPath("reserved", "dynamic");
                                object = null;
                                out22 = null;
                                try (BufferedWriter out = Files.newBufferedWriter(dynamicPath, new OpenOption[0]);){
                                    MapMapper.write(out, config.getDynamicProperties(), "dynamic-properties");
                                }
                                catch (Throwable out22) {
                                    if (object == null) {
                                        object = out22;
                                        throw object;
                                    }
                                    if (object == out22) throw object;
                                    ((Throwable)object).addSuppressed(out22);
                                    throw object;
                                }
                            }
                            handler.startDownloads();
                            object = requiresUpdate.iterator();
                            while (true) {
                                Path output;
                                FileMetadata file2;
                                block59: {
                                    if (!object.hasNext()) {
                                        doneDownloads = true;
                                        break block28;
                                    }
                                    file2 = (FileMetadata)object.next();
                                    handler.startDownloadFile(file2);
                                    output = FileUtils.resolve(zip.getPath("files", new String[0]), file2.getNormalizedPath());
                                    Files.createDirectories(output.getParent(), new FileAttribute[0]);
                                    int read = 0;
                                    double currentCompleted = 0.0;
                                    byte[] buffer = new byte[8192];
                                    Throwable throwable4 = null;
                                    Object var33_40 = null;
                                    try {
                                        InputStream in = handler.openDownloadStream(file2);
                                        try {
                                            try (OutputStream out = Files.newOutputStream(output, new OpenOption[0]);){
                                                if (downloadJobCompleted == 0.0) {
                                                    handler.updateDownloadProgress(0.0f);
                                                }
                                                handler.updateDownloadFileProgress(file2, 0.0f);
                                                while ((read = in.read(buffer, 0, buffer.length)) > -1) {
                                                    out.write(buffer, 0, read);
                                                    if (sig != null) {
                                                        sig.update(buffer, 0, read);
                                                    }
                                                    handler.updateDownloadFileProgress(file2, ConfigImpl.clamp((float)((currentCompleted += (double)read) / (double)file2.getSize())));
                                                    handler.updateDownloadProgress(ConfigImpl.clamp((float)(downloadJobCompleted += (double)read) / (float)downloadJobSize));
                                                }
                                            }
                                            if (in == null) break block59;
                                        }
                                        catch (Throwable throwable5) {
                                            if (throwable4 == null) {
                                                throwable4 = throwable5;
                                            } else if (throwable4 != throwable5) {
                                                throwable4.addSuppressed(throwable5);
                                            }
                                            if (in == null) throw throwable4;
                                            in.close();
                                            throw throwable4;
                                        }
                                        in.close();
                                    }
                                    catch (Throwable throwable6) {
                                        if (throwable4 == null) {
                                            throwable4 = throwable6;
                                            throw throwable4;
                                        }
                                        if (throwable4 == throwable6) throw throwable4;
                                        throwable4.addSuppressed(throwable6);
                                        throw throwable4;
                                    }
                                }
                                handler.validatingFile(file2, output);
                                ConfigImpl.validateFile(file2, output, sig);
                                updated.add(file2);
                                handler.doneDownloadFile(file2, output);
                            }
                        }
                        catch (Throwable throwable7) {
                            if (throwable == null) {
                                throwable = throwable7;
                                throw throwable;
                            }
                            if (throwable == throwable7) throw throwable;
                            throwable.addSuppressed(throwable7);
                            throw throwable;
                        }
                    }
                    FileMetadata file3 = (FileMetadata)iterator.next();
                    if (handler.shouldCheckForUpdate(file3)) {
                        handler.startCheckUpdateFile(file3);
                        boolean needsUpdate = file3.requiresUpdate();
                        if (needsUpdate) {
                            requiresUpdate.add(file3);
                        }
                        handler.doneCheckUpdateFile(file3, needsUpdate);
                    }
                    handler.updateCheckUpdatesProgress(ConfigImpl.clamp((float)((updateJobCompleted += (double)file3.getSize()) / (double)updateJobSize)));
                }
                handler.doneDownloads();
            }
            success = true;
        }
        catch (Throwable t) {
            exception = t;
            if (!doneDownloads) {
                try {
                    Files.deleteIfExists(options.getArchiveLocation());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Warning.lock(t);
            success = false;
            handler.failed(t);
        }
        if (success) {
            handler.succeeded();
        }
        handler.stop();
        return new UpdateResult(handler, exception);
    }

    @Deprecated
    private static void completeDownloads(Map<FileMetadata, Path> files, Path tempDir, boolean isTemp) throws IOException {
        if (!files.isEmpty()) {
            if (!isTemp) {
                for (Path path : files.values()) {
                    if (!Files.notExists(path, new LinkOption[0])) continue;
                    throw new NoSuchFileException(path.toString());
                }
                for (FileMetadata fileMetadata : files.keySet()) {
                    FileUtils.verifyAccessible(fileMetadata.getNormalizedPath());
                }
                for (Map.Entry entry : files.entrySet()) {
                    FileUtils.secureMoveFile((Path)entry.getValue(), ((FileMetadata)entry.getKey()).getNormalizedPath());
                }
            } else {
                Path path = tempDir.resolve(Update.UPDATE_DATA);
                HashMap<File, File> updateTempData = new HashMap<File, File>();
                for (Map.Entry<FileMetadata, Path> entry : files.entrySet()) {
                    updateTempData.put(entry.getValue().toFile(), entry.getKey().getNormalizedPath().toFile());
                }
                Throwable throwable = null;
                Iterator<Map.Entry<FileMetadata, Path>> iterator = null;
                try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(path, StandardOpenOption.CREATE));){
                    out.writeObject(updateTempData);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                FileUtils.windowsHidden(path, true);
            }
        }
    }

    private static void validateFile(FileMetadata file, Path output, Signature sig) throws IOException, SignatureException {
        long actualSize = Files.size(output);
        if (actualSize != file.getSize()) {
            throw new IllegalStateException("Size of file '" + file.getPath().getFileName() + "' does not match size in configuration. Expected: " + file.getSize() + ", found: " + actualSize);
        }
        long actualChecksum = FileUtils.getChecksum(output);
        if (actualChecksum != file.getChecksum()) {
            throw new IllegalStateException("Checksum of file '" + file.getPath().getFileName() + "' does not match checksum in configuration. Expected: " + Long.toHexString(file.getChecksum()) + ", found: " + Long.toHexString(actualChecksum));
        }
        if (sig != null) {
            if (file.getSignature() == null) {
                throw new SecurityException("Missing signature.");
            }
            if (!sig.verify(Base64.getDecoder().decode(file.getSignature()))) {
                throw new SecurityException("Signature verification failed.");
            }
        }
        if (file.getPath().toString().endsWith(".jar") && !file.isIgnoreBootConflict() && !ModuleUtils.userBootModules().isEmpty()) {
            ConfigImpl.checkBootConflicts(file, output);
        }
    }

    private static void checkBootConflicts(FileMetadata file, Path download) throws IOException {
        String filename = file.getPath().getFileName().toString();
        if (!FileUtils.isZipFile(download)) {
            Warning.nonZip(filename);
            throw new IllegalStateException("File '" + filename + "' is not a valid zip file.");
        }
        Set<Module> modules = ModuleLayer.boot().modules();
        Set moduleNames = modules.stream().map(Module::getName).collect(Collectors.toSet());
        Set sysMods = ModuleFinder.ofSystem().findAll().stream().map(mr -> mr.descriptor().name()).collect(Collectors.toSet());
        ModuleDescriptor newMod = null;
        try {
            newMod = ModuleUtils.deriveModuleDescriptor(download, filename, sysMods.contains("jdk.zipfs"));
        }
        catch (IllegalArgumentException | FindException | InvalidModuleDescriptorException e) {
            Warning.illegalModule(filename);
            throw e;
        }
        if (moduleNames.contains(newMod.name())) {
            Warning.moduleConflict(newMod.name());
            throw new IllegalStateException("Module '" + newMod.name() + "' conflicts with a module in the boot modulepath");
        }
        Set packages = modules.stream().flatMap(m -> m.getPackages().stream()).collect(Collectors.toSet());
        for (String p : newMod.packages()) {
            if (!packages.contains(p)) continue;
            Warning.packageConflict(p);
            throw new IllegalStateException("Package '" + p + "' in module '" + newMod.name() + "' conflicts with a package in the boot modulepath");
        }
        for (ModuleDescriptor.Requires require : newMod.requires()) {
            String reqName;
            if (require.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC) || !StringUtils.isSystemModule(reqName = require.name()) || sysMods.contains(reqName)) continue;
            Warning.missingSysMod(reqName);
            throw new IllegalStateException("System module '" + reqName + "' is missing from JVM image, required by '" + newMod.name() + "'");
        }
    }

    static void doLaunch(Configuration config, Injectable injectable, Launcher launcher) {
        boolean usingSpi;
        List modules = config.getFiles().stream().filter(file -> file.getOs() == null || file.getOs() == OS.CURRENT).filter(FileMetadata::isModulepath).collect(Collectors.toList());
        List<Path> modulepaths = modules.stream().map(FileMetadata::getNormalizedPath).collect(Collectors.toList());
        List<URL> classpaths = config.getFiles().stream().filter(file -> file.getOs() == null || file.getOs() == OS.CURRENT).filter(FileMetadata::isClasspath).map(FileMetadata::getNormalizedPath).map(path -> {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        if (modulepaths.isEmpty() && classpaths.isEmpty()) {
            Warning.path();
        }
        ModuleFinder finder = ModuleFinder.of(modulepaths.toArray(new Path[modulepaths.size()]));
        Set moduleDescriptors = finder.findAll().stream().map(mr -> mr.descriptor()).collect(Collectors.toSet());
        if (Warning.shouldWarn("unresolvedSystemModules")) {
            Set resolvedSysMods = ModuleLayer.boot().modules().stream().map(m -> m.getName()).collect(Collectors.toSet());
            ArrayList<String> missingSysMods = new ArrayList<String>();
            for (ModuleDescriptor descriptor : moduleDescriptors) {
                for (ModuleDescriptor.Requires require : descriptor.requires()) {
                    Object reqName;
                    if (require.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC) || !StringUtils.isSystemModule((String)(reqName = require.name())) || resolvedSysMods.contains(reqName)) continue;
                    missingSysMods.add((String)reqName);
                }
            }
            if (missingSysMods.size() > 0) {
                Warning.unresolvedSystemModules(missingSysMods);
            }
        }
        List<String> moduleNames = moduleDescriptors.stream().map(ModuleDescriptor::name).collect(Collectors.toList());
        ModuleLayer parent = ModuleLayer.boot();
        java.lang.module.Configuration cf = parent.configuration().resolveAndBind(finder, ModuleFinder.of(new Path[0]), moduleNames);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        DynamicClassLoader dynamic = DynamicClassLoader.findAncestor(contextClassLoader);
        if (dynamic != null) {
            for (URL url : classpaths) {
                dynamic.add(url);
            }
        } else if (classpaths.size() > 0) {
            contextClassLoader = new URLClassLoader("classpath", classpaths.toArray(new URL[classpaths.size()]), contextClassLoader);
        }
        ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(cf, List.of(parent), contextClassLoader);
        ModuleLayer layer = controller.layer();
        for (FileMetadata mod : modules) {
            Module target;
            if (mod.getAddExports().isEmpty() && mod.getAddOpens().isEmpty() && mod.getAddReads().isEmpty()) continue;
            ModuleReference reference = finder.findAll().stream().filter(ref -> new File(ref.location().get()).toPath().equals(mod.getNormalizedPath())).findFirst().orElseThrow(IllegalStateException::new);
            Module source = layer.findModule(reference.descriptor().name()).orElseThrow(IllegalStateException::new);
            for (AddPackage export : mod.getAddExports()) {
                target = layer.findModule(export.getTargetModule()).orElseThrow(() -> new IllegalStateException("Module '" + export.getTargetModule() + "' is not known to the layer."));
                controller.addExports(source, export.getPackageName(), target);
            }
            for (AddPackage open : mod.getAddOpens()) {
                target = layer.findModule(open.getTargetModule()).orElseThrow(() -> new IllegalStateException("Module '" + open.getTargetModule() + "' is not known to the layer."));
                controller.addOpens(source, open.getPackageName(), target);
            }
            for (String read : mod.getAddReads()) {
                target = layer.findModule(read).orElseThrow(() -> new IllegalStateException("Module '" + read + "' is not known to the layer."));
                controller.addReads(source, target);
            }
        }
        if (moduleNames.size() > 0) {
            contextClassLoader = layer.findLoader(moduleNames.get(0));
        }
        LaunchContext ctx = new LaunchContext(layer, contextClassLoader, config);
        boolean bl = usingSpi = launcher == null;
        if (usingSpi) {
            launcher = Service.loadService(layer, contextClassLoader, Launcher.class, config.getLauncher());
            if (injectable != null) {
                try {
                    Injectable.injectBidirectional(injectable, launcher);
                }
                catch (IllegalAccessException | InvocationTargetException | UnsatisfiedInjectionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Launcher finalLauncher = launcher;
        Thread t = new Thread(() -> {
            try {
                finalLauncher.run(ctx);
            }
            catch (NoClassDefFoundError e) {
                if (usingSpi) {
                    if (finalLauncher.getClass().getClassLoader() == ClassLoader.getSystemClassLoader()) {
                        Warning.access(finalLauncher);
                    }
                } else {
                    Warning.reflectiveAccess(finalLauncher);
                }
                throw e;
            }
        });
        t.setContextClassLoader(contextClassLoader);
        t.start();
        while (t.isAlive()) {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static float clamp(float val) {
        return Math.max(0.0f, Math.min(1.0f, val));
    }
}

