/*
 * Decompiled with CFR 0.152.
 */
package org.update4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.update4j.ConfigImpl;
import org.update4j.FileMetadata;
import org.update4j.OS;
import org.update4j.PlaceholderMatchType;
import org.update4j.Property;
import org.update4j.UpdateOptions;
import org.update4j.UpdateResult;
import org.update4j.inject.Injectable;
import org.update4j.mapper.ConfigMapper;
import org.update4j.mapper.FileMapper;
import org.update4j.service.Launcher;
import org.update4j.service.UpdateHandler;
import org.update4j.util.FileUtils;
import org.update4j.util.PropertyManager;
import org.update4j.util.StringUtils;

public class Configuration {
    private static final System.Logger logger = System.getLogger(Configuration.class.getName());
    private Instant timestamp;
    private String signature;
    private URI baseUri;
    private Path basePath;
    private String updateHandler;
    private String launcher;
    private List<FileMetadata> unmodifiableFiles;
    private PropertyManager propertyManager;
    private ConfigMapper mapper;

    private Configuration() {
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getSignature() {
        return this.signature;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public String getUpdateHandler() {
        return this.updateHandler;
    }

    public String getLauncher() {
        return this.launcher;
    }

    public List<FileMetadata> getFiles() {
        return this.unmodifiableFiles;
    }

    public List<Property> getProperties() {
        return this.propertyManager.getProperties();
    }

    public List<Property> getProperties(String key) {
        return this.propertyManager.getProperties(key);
    }

    public Map<String, String> getResolvedProperties() {
        return this.propertyManager.getResolvedProperties();
    }

    public String getResolvedProperty(String key) {
        return this.propertyManager.getResolvedProperty(key);
    }

    public Map<String, String> getDynamicProperties() {
        return this.propertyManager.getDynamicProperties();
    }

    public String resolvePlaceholders(String str) {
        return this.propertyManager.resolvePlaceholders(str);
    }

    private String resolvePlaceholders(String str, boolean isPath) {
        return this.propertyManager.resolvePlaceholders(str, isPath);
    }

    private String resolvePlaceholders(String str, boolean isPath, boolean ignoreForeignProperty) {
        return this.propertyManager.resolvePlaceholders(str, isPath, ignoreForeignProperty);
    }

    public String implyPlaceholders(String str) {
        return this.propertyManager.implyPlaceholders(str);
    }

    public String implyPlaceholders(String str, boolean isPath) {
        return this.propertyManager.implyPlaceholders(str, isPath);
    }

    public String implyPlaceholders(String str, PlaceholderMatchType matchType) {
        return this.propertyManager.implyPlaceholders(str, matchType);
    }

    public String implyPlaceholders(String str, PlaceholderMatchType matchType, boolean isPath) {
        return this.propertyManager.implyPlaceholders(str, matchType, isPath);
    }

    public boolean requiresUpdate() throws IOException {
        for (FileMetadata file : this.getFiles()) {
            if (!file.requiresUpdate()) continue;
            return true;
        }
        return false;
    }

    public UpdateResult update(UpdateOptions.ArchiveUpdateOptions options) {
        return ConfigImpl.doUpdate(this, options);
    }

    @Deprecated
    public boolean update() {
        return this.update((PublicKey)null);
    }

    @Deprecated
    public boolean update(UpdateHandler handler) {
        return this.update(null, handler);
    }

    @Deprecated
    public boolean update(Injectable injectable) {
        return this.update(null, injectable);
    }

    @Deprecated
    public boolean update(PublicKey key) {
        return this.update(key, null);
    }

    @Deprecated
    public boolean update(PublicKey key, Injectable injectable) {
        return ConfigImpl.doLegacyUpdate(this, null, key, injectable, null);
    }

    @Deprecated
    public boolean update(PublicKey key, UpdateHandler handler) {
        return ConfigImpl.doLegacyUpdate(this, null, key, null, handler);
    }

    @Deprecated
    public boolean updateTemp(Path tempDir) {
        return this.updateTemp(tempDir, (PublicKey)null);
    }

    @Deprecated
    public boolean updateTemp(Path tempDir, Injectable injectable) {
        return this.updateTemp(tempDir, null, injectable);
    }

    @Deprecated
    public boolean updateTemp(Path tempDir, UpdateHandler handler) {
        return this.updateTemp(tempDir, null, handler);
    }

    @Deprecated
    public boolean updateTemp(Path tempDir, PublicKey key) {
        return this.updateTemp(tempDir, key, null);
    }

    @Deprecated
    public boolean updateTemp(Path tempDir, PublicKey key, Injectable injectable) {
        return ConfigImpl.doLegacyUpdate(this, Objects.requireNonNull(tempDir), key, injectable, null);
    }

    @Deprecated
    public boolean updateTemp(Path tempDir, PublicKey key, UpdateHandler handler) {
        return ConfigImpl.doLegacyUpdate(this, Objects.requireNonNull(tempDir), key, null, handler);
    }

    public void launch() {
        this.launch(null);
    }

    public void launch(Injectable injectable) {
        ConfigImpl.doLaunch(this, injectable, null);
    }

    public void launch(Launcher launcher) {
        ConfigImpl.doLaunch(this, null, launcher);
    }

    public void deleteOldFiles(Configuration oldConfig) throws IOException {
        this.deleteOldFiles(oldConfig, true, 5);
    }

    public void deleteOldFiles(Configuration oldConfig, boolean matchChecksum, int secondsDelay) throws IOException {
        if (this.requiresUpdate()) {
            throw new IllegalStateException("Current configuration is not up-to-date, refusing to delete.");
        }
        List<FileMetadata> oldFiles = this.getOldFiles(oldConfig, matchChecksum);
        if (oldFiles.isEmpty()) {
            return;
        }
        ArrayList<Path> delayedDelete = new ArrayList<Path>();
        for (FileMetadata file : oldFiles) {
            if (file.isClasspath() || file.isModulepath()) {
                try {
                    Files.deleteIfExists(file.getPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    delayedDelete.add(file.getPath());
                }
                continue;
            }
            delayedDelete.add(file.getPath());
        }
        if (!delayedDelete.isEmpty()) {
            FileUtils.delayedDelete(delayedDelete, secondsDelay);
        }
    }

    public List<FileMetadata> getOldFiles(Configuration oldConfig, boolean matchChecksum) throws IOException {
        ArrayList<FileMetadata> oldFiles = new ArrayList<FileMetadata>();
        block0: for (FileMetadata file : oldConfig.getFiles()) {
            if (!Files.exists(file.getPath(), new LinkOption[0]) || this.getFiles().stream().anyMatch(f -> (f.getOs() == null || f.getOs() == OS.CURRENT) && f.getPath().equals(file.getPath()))) continue;
            for (FileMetadata newFile : this.getFiles()) {
                if ((newFile.getOs() == null || newFile.getOs() == OS.CURRENT) && Files.isSameFile(newFile.getPath(), file.getPath())) continue block0;
            }
            if (matchChecksum && file.requiresUpdate()) continue;
            oldFiles.add(file);
        }
        return oldFiles;
    }

    public static Configuration read(Reader reader) throws IOException {
        return Configuration.read(reader, null);
    }

    public static Configuration read(Reader reader, Map<String, String> dynamicProperties) throws IOException {
        return Configuration.doRead(reader, dynamicProperties);
    }

    public static Configuration read(Reader reader, PublicKey key) throws IOException {
        return Configuration.read(reader, key, null);
    }

    public static Configuration read(Reader reader, PublicKey key, Map<String, String> dynamicProperties) throws IOException {
        Configuration config = Configuration.doRead(reader, dynamicProperties);
        config.verifyConfiguration(key);
        return config;
    }

    private static Configuration doRead(Reader reader, Map<String, String> dynamicProperties) throws IOException {
        ConfigMapper configMapper = ConfigMapper.read(reader);
        return Configuration.parseNoCopy(configMapper, dynamicProperties);
    }

    public static Configuration parse(ConfigMapper mapper) {
        return Configuration.parse(mapper, null);
    }

    public static Configuration parse(ConfigMapper mapper, Map<String, String> dynamicProperties) {
        return Configuration.parseNoCopy(new ConfigMapper(mapper), dynamicProperties);
    }

    private static Configuration parseNoCopy(ConfigMapper mapper, Map<String, String> dynamicProperties) {
        PropertyManager manager = new PropertyManager(mapper.properties, dynamicProperties, null);
        return Configuration.parseNoCopy(mapper, manager);
    }

    private static Configuration parseNoCopy(ConfigMapper configMapper, PropertyManager propertyManager) {
        Configuration config = new Configuration();
        config.propertyManager = propertyManager;
        if (configMapper.timestamp != null) {
            config.timestamp = Instant.parse(configMapper.timestamp);
        }
        config.signature = configMapper.signature;
        if (configMapper.baseUri != null) {
            String uri = config.resolvePlaceholders(configMapper.baseUri, true);
            if (!uri.endsWith("/")) {
                uri = String.valueOf(uri) + "/";
            }
            config.baseUri = URI.create(uri);
        }
        if (configMapper.basePath != null) {
            config.basePath = Paths.get(config.resolvePlaceholders(configMapper.basePath, true), new String[0]);
        }
        if (configMapper.updateHandler != null) {
            config.updateHandler = config.resolvePlaceholders(configMapper.updateHandler, false);
            if (!StringUtils.isClassName(config.updateHandler)) {
                throw new IllegalStateException(String.valueOf(config.updateHandler) + " is not a valid Java class name.");
            }
        }
        if (configMapper.launcher != null) {
            config.launcher = config.resolvePlaceholders(configMapper.launcher, false);
            if (!StringUtils.isClassName(config.launcher)) {
                throw new IllegalStateException(String.valueOf(config.launcher) + " is not a valid Java class name.");
            }
        }
        ArrayList<FileMetadata> files = new ArrayList<FileMetadata>();
        for (FileMapper fm : configMapper.files) {
            String s;
            FileMetadata.Builder fileBuilder = FileMetadata.builder().baseUri(config.getBaseUri()).basePath(config.getBasePath());
            if (fm.uri != null && !PropertyManager.containsPlaceholder(s = config.resolvePlaceholders(fm.uri, true, fm.os != null && fm.os != OS.CURRENT))) {
                fileBuilder.uri(URI.create(s));
            }
            if (fm.path != null && !PropertyManager.containsPlaceholder(s = config.resolvePlaceholders(fm.path, true, fm.os != null && fm.os != OS.CURRENT))) {
                fileBuilder.path(Paths.get(s, new String[0]));
            }
            if (fm.checksum != null) {
                fileBuilder.checksum(fm.checksum);
            }
            if (fm.size != null) {
                fileBuilder.size(fm.size);
            }
            if (fm.os != null) {
                fileBuilder.os(fm.os);
            }
            fileBuilder.modulepath(fm.modulepath != null && fm.modulepath != false);
            fileBuilder.classpath(fm.classpath != null && fm.classpath != false);
            fileBuilder.ignoreBootConflict(fm.ignoreBootConflict != null && fm.ignoreBootConflict != false);
            if (fm.comment != null) {
                fileBuilder.comment(config.resolvePlaceholders(fm.comment, false));
            }
            if (fm.signature != null) {
                fileBuilder.signature(fm.signature);
            }
            fileBuilder.exports(fm.addExports);
            fileBuilder.opens(fm.addOpens);
            fileBuilder.reads(fm.addReads);
            FileMetadata file = fileBuilder.build();
            for (FileMetadata prevFile : files) {
                if (prevFile.getPath() == null || file.getPath() == null || prevFile.getOs() != null && file.getOs() != null && prevFile.getOs() != file.getOs() || !prevFile.getPath().equals(file.getPath())) continue;
                throw new IllegalStateException("2 files resolve to same 'path': " + file.getPath());
            }
            files.add(file);
        }
        config.unmodifiableFiles = Collections.unmodifiableList(files);
        config.mapper = configMapper;
        return config;
    }

    public Configuration sync() throws IOException {
        return this.sync(null, null);
    }

    public Configuration sync(Path overrideBasePath) throws IOException {
        return this.sync(overrideBasePath, null);
    }

    public Configuration sync(PrivateKey signer) throws IOException {
        return this.sync(null, signer);
    }

    public Configuration sync(Path overrideBasePath, PrivateKey signer) throws IOException {
        ConfigMapper newMapper = this.generateXmlMapper();
        boolean changed = false;
        int i = 0;
        while (i < this.getFiles().size()) {
            FileMetadata fm = this.getFiles().get(i);
            Path path = overrideBasePath == null || this.getBasePath().relativize(fm.getPath()).isAbsolute() ? fm.getPath() : overrideBasePath.resolve(this.getBasePath().relativize(fm.getPath()));
            if (Files.notExists(path, new LinkOption[0])) {
                logger.log(System.Logger.Level.WARNING, "File '" + path + "' is missing; skipped.");
            } else {
                FileMapper fileMapper = newMapper.files.get(i);
                long checksum = FileUtils.getChecksum(path);
                fileMapper.size = Files.size(path);
                fileMapper.checksum = Long.toString(checksum, 16);
                fileMapper.signature = signer == null ? null : Base64.getEncoder().encodeToString(FileUtils.sign(path, signer));
                if (fm.getSize() != fileMapper.size.longValue() || fm.getChecksum() != checksum) {
                    logger.log(System.Logger.Level.INFO, "Synced '" + path.getFileName() + "'.");
                    changed = true;
                }
            }
            ++i;
        }
        if (changed) {
            newMapper.timestamp = Instant.now().toString();
        }
        newMapper.signature = signer == null ? null : newMapper.sign(signer);
        return Configuration.parseNoCopy(newMapper, this.propertyManager);
    }

    public void verifyConfiguration(PublicKey key) {
        this.mapper.verifySignature(key);
    }

    public ConfigMapper generateXmlMapper() {
        return new ConfigMapper(this.mapper);
    }

    public void write(Writer writer) throws IOException {
        this.mapper.write(writer);
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            this.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Configuration)) {
            return false;
        }
        Configuration otherConfig = (Configuration)other;
        if (this.getTimestamp() == null ? otherConfig.getTimestamp() != null : !this.getTimestamp().equals(otherConfig.getTimestamp())) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String baseUri;
        private String basePath;
        private String updateHandler;
        private String launcher;
        private List<FileMetadata.Reference> files = new ArrayList<FileMetadata.Reference>();
        private List<Property> properties = new ArrayList<Property>();
        private List<String> systemProperties = new ArrayList<String>();
        private Map<String, String> dynamicProperties = new HashMap<String, String>();
        private PrivateKey signer;
        private PlaceholderMatchType matcher;

        private Builder() {
            this.resolveSystemProperty("user.home");
            this.resolveSystemProperty("user.dir");
        }

        public Builder baseUri(String uri) {
            this.baseUri = uri;
            return this;
        }

        public Builder baseUri(URI uri) {
            return this.baseUri(uri == null ? null : uri.toString());
        }

        public String getBaseUri() {
            return this.baseUri;
        }

        public Builder basePath(String path) {
            this.basePath = path;
            return this;
        }

        public Builder basePath(Path path) {
            return this.basePath(path == null ? null : path.toString());
        }

        public String getBasePath() {
            return this.basePath;
        }

        public Builder signer(PrivateKey key) {
            this.signer = key;
            return this;
        }

        public Builder signer(Path path, char[] keystorePass, String alias, char[] aliasPass) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                    KeyStore jks = KeyStore.getInstance("JKS");
                    jks.load(in, keystorePass);
                    PrivateKey key = (PrivateKey)jks.getKey(alias, aliasPass);
                    return this.signer(key);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Builder signer(String path, char[] keystorePass, String alias, char[] aliasPass) {
            return this.signer(Paths.get(path, new String[0]), keystorePass, alias, aliasPass);
        }

        public Builder signer(char[] keystorePass, String alias, char[] aliasPass) {
            return this.signer(Paths.get(System.getProperty("user.home"), ".keystore"), keystorePass, alias, aliasPass);
        }

        public PrivateKey getSigner() {
            return this.signer;
        }

        public Builder file(FileMetadata.Reference reference) {
            this.files.add(reference);
            return this;
        }

        public Builder files(Collection<FileMetadata.Reference> refs) {
            this.files.addAll(refs);
            return this;
        }

        public Builder files(Stream<FileMetadata.Reference> fileStream) {
            this.files.addAll(fileStream.collect(Collectors.toList()));
            return this;
        }

        public List<FileMetadata.Reference> getFiles() {
            return this.files;
        }

        public Builder property(String key, String value) {
            return this.property(key, value, null);
        }

        public Builder property(String key, String value, OS os) {
            this.properties.add(new Property(key, value, os));
            return this;
        }

        public Builder property(Property p) {
            this.properties.add(p);
            return this;
        }

        public Builder properties(Collection<Property> props) {
            this.properties.addAll(props);
            return this;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public Builder dynamicProperty(String key, String value) {
            this.dynamicProperties.put(key, value);
            return this;
        }

        public Builder dynamicProperties(Map<String, String> dynamics) {
            this.dynamicProperties.putAll(dynamics);
            return this;
        }

        public Map<String, String> getDynamicProperties() {
            return this.dynamicProperties;
        }

        public Builder resolveSystemProperty(String str) {
            this.systemProperties.add(str);
            return this;
        }

        public Builder resolveSystemProperties(Collection<String> p) {
            this.systemProperties.addAll(p);
            return this;
        }

        public List<String> getSystemPropertiesToResolve() {
            return this.systemProperties;
        }

        public Builder updateHandler(Class<? extends UpdateHandler> clazz) {
            return this.updateHandler(clazz.getCanonicalName());
        }

        public Builder updateHandler(String className) {
            this.updateHandler = className;
            return this;
        }

        public String getUpdateHandler() {
            return this.updateHandler;
        }

        public Builder launcher(Class<? extends Launcher> clazz) {
            return this.launcher(clazz.getCanonicalName());
        }

        public Builder launcher(String className) {
            this.launcher = className;
            return this;
        }

        public String getLauncher() {
            return this.launcher;
        }

        public Builder matchAndReplace(PlaceholderMatchType matcher) {
            this.matcher = matcher;
            return this;
        }

        public PlaceholderMatchType getMatchType() {
            return this.matcher == null ? PlaceholderMatchType.WHOLE_WORD : this.matcher;
        }

        public Configuration build() {
            PlaceholderMatchType matcher = this.getMatchType();
            for (Map.Entry<String, String> e : this.dynamicProperties.entrySet()) {
                Objects.requireNonNull(e.getKey());
                Objects.requireNonNull(e.getValue());
            }
            ConfigMapper mapper = new ConfigMapper();
            PropertyManager pm = new PropertyManager(this.properties, this.dynamicProperties, this.systemProperties);
            mapper.timestamp = Instant.now().toString();
            if (this.baseUri != null) {
                mapper.baseUri = pm.implyPlaceholders(this.baseUri, matcher, true);
            }
            if (this.basePath != null) {
                mapper.basePath = pm.implyPlaceholders(this.basePath, matcher, true);
            }
            if (this.updateHandler != null) {
                mapper.updateHandler = pm.implyPlaceholders(this.updateHandler, matcher, false);
            }
            if (this.launcher != null) {
                mapper.launcher = pm.implyPlaceholders(this.launcher, matcher, false);
            }
            if (!this.properties.isEmpty()) {
                mapper.properties.addAll(this.properties);
            }
            if (!this.files.isEmpty()) {
                for (FileMetadata.Reference fileRef : this.files) {
                    mapper.files.add(fileRef.getFileMapper(pm, this.baseUri, this.basePath, matcher, this.signer));
                }
            }
            if (this.getSigner() != null) {
                mapper.signature = mapper.sign(this.getSigner());
            }
            return Configuration.parseNoCopy(mapper, pm);
        }
    }
}

