/*
 * Decompiled with CFR 0.152.
 */
package org.update4j;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public final class DynamicClassLoader
extends URLClassLoader {
    static {
        DynamicClassLoader.registerAsParallelCapable();
    }

    public DynamicClassLoader(String name, ClassLoader parent) {
        super(name, new URL[0], parent);
    }

    public DynamicClassLoader(ClassLoader parent) {
        this("classpath", parent);
    }

    public DynamicClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    void add(URL url) {
        this.addURL(url);
    }

    public static DynamicClassLoader findAncestor(ClassLoader cl) {
        do {
            if (!(cl instanceof DynamicClassLoader)) continue;
            return (DynamicClassLoader)cl;
        } while ((cl = cl.getParent()) != null);
        return null;
    }

    private void appendToClassPathForInstrumentation(String jarfile) throws IOException {
        this.add(Paths.get(jarfile, new String[0]).toRealPath(new LinkOption[0]).toUri().toURL());
    }
}

