/*
 * Decompiled with CFR 0.152.
 */
package org.update4j;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.update4j.AddPackage;
import org.update4j.OS;
import org.update4j.PlaceholderMatchType;
import org.update4j.mapper.FileMapper;
import org.update4j.util.FileUtils;
import org.update4j.util.PropertyManager;

public class FileMetadata {
    private final URI uri;
    private final Path path;
    private Path normalizedPath;
    private final OS os;
    private final long checksum;
    private final long size;
    private final boolean classpath;
    private final boolean modulepath;
    private final String comment;
    private final boolean ignoreBootConflict;
    private final String signature;
    private final List<AddPackage> addExports;
    private final List<AddPackage> addOpens;
    private final List<String> addReads;

    private FileMetadata(URI uri, Path path, OS os, long checksum, long size, boolean classpath, boolean modulepath, String comment, boolean ignoreBootConflict, String signature, List<AddPackage> addExports, List<AddPackage> addOpens, List<String> addReads) {
        this.uri = uri;
        if (os == null || os == OS.CURRENT) {
            Objects.requireNonNull(uri, "uri");
            if (!uri.isAbsolute()) {
                throw new IllegalArgumentException("Absolute uri required: " + uri);
            }
        }
        this.path = path;
        if (os == null || os == OS.CURRENT) {
            Objects.requireNonNull(path, "path");
            if (!path.isAbsolute()) {
                throw new IllegalArgumentException("Absolute path required: " + path);
            }
        }
        this.os = os;
        if (checksum < 0L) {
            throw new IllegalArgumentException("Negative checksum: " + checksum);
        }
        this.checksum = checksum;
        if (size < 0L) {
            throw new IllegalArgumentException("Negative file size: " + size);
        }
        this.size = size;
        this.classpath = classpath;
        this.modulepath = modulepath;
        this.comment = comment;
        this.ignoreBootConflict = ignoreBootConflict;
        this.signature = signature;
        this.addExports = Collections.unmodifiableList(new ArrayList<AddPackage>(addExports));
        this.addOpens = Collections.unmodifiableList(new ArrayList<AddPackage>(addOpens));
        this.addReads = Collections.unmodifiableList(new ArrayList<String>(addReads));
    }

    public URI getUri() {
        return this.uri;
    }

    public Path getPath() {
        return this.path;
    }

    Path getNormalizedPath() {
        if (this.getPath() == null) {
            return null;
        }
        if (this.normalizedPath == null) {
            this.normalizedPath = this.path.normalize();
        }
        return this.normalizedPath;
    }

    public OS getOs() {
        return this.os;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isClasspath() {
        return this.classpath;
    }

    public boolean isModulepath() {
        return this.modulepath;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isIgnoreBootConflict() {
        return this.ignoreBootConflict;
    }

    public String getSignature() {
        return this.signature;
    }

    public List<AddPackage> getAddExports() {
        return this.addExports;
    }

    public List<AddPackage> getAddOpens() {
        return this.addOpens;
    }

    public List<String> getAddReads() {
        return this.addReads;
    }

    public boolean requiresUpdate() throws IOException {
        if (this.getOs() != null && this.getOs() != OS.CURRENT) {
            return false;
        }
        return Files.notExists(this.getPath(), new LinkOption[0]) || Files.size(this.getPath()) != this.getSize() || FileUtils.getChecksum(this.getPath()) != this.getChecksum();
    }

    public static Reference readFrom(Path source) {
        return new Reference(source);
    }

    public static Reference readFrom(String source) {
        return FileMetadata.readFrom(Paths.get(source, new String[0]));
    }

    public static Stream<Reference> streamDirectory(Path dir) {
        try {
            return Files.walk(dir, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0])).map(FileMetadata::readFrom).peek(fm -> {
                Reference reference = fm.path(dir.relativize(fm.getSource()));
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<Reference> streamDirectory(String dir) {
        return FileMetadata.streamDirectory(Paths.get(dir, new String[0]));
    }

    static Builder builder() {
        return new Builder();
    }

    /* synthetic */ FileMetadata(URI uRI, Path path, OS oS, long l, long l2, boolean bl, boolean bl2, String string, boolean bl3, String string2, List list, List list2, List list3, FileMetadata fileMetadata) {
        this(uRI, path, oS, l, l2, bl, bl2, string, bl3, string2, list, list2, list3);
    }

    static class Builder {
        private URI baseUri;
        private Path basePath;
        private URI uri;
        private Path path;
        private OS os;
        private long checksum;
        private long size;
        private boolean classpath;
        private boolean modulepath;
        private String comment;
        private boolean ignoreBootConflict;
        private String signature;
        private List<AddPackage> addExports = new ArrayList<AddPackage>();
        private List<AddPackage> addOpens = new ArrayList<AddPackage>();
        private List<String> addReads = new ArrayList<String>();

        private Builder() {
        }

        Builder baseUri(URI uri) {
            this.baseUri = uri;
            return this;
        }

        Builder basePath(Path path) {
            this.basePath = path;
            return this;
        }

        Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        Builder path(Path path) {
            this.path = path;
            return this;
        }

        Builder os(OS os) {
            this.os = os;
            return this;
        }

        Builder checksum(long checksum) {
            this.checksum = checksum;
            return this;
        }

        Builder checksum(String checksum) {
            return this.checksum(Long.parseLong(checksum, 16));
        }

        Builder size(long size) {
            this.size = size;
            return this;
        }

        Builder classpath(boolean cp) {
            this.classpath = cp;
            return this;
        }

        Builder modulepath(boolean mp) {
            this.modulepath = mp;
            return this;
        }

        Builder ignoreBootConflict(boolean b) {
            this.ignoreBootConflict = b;
            return this;
        }

        Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        private void validateAddReads(List<String> list) {
            for (String read : list) {
                Objects.requireNonNull(read);
                if (!read.isEmpty()) continue;
                throw new IllegalArgumentException("Missing module name.");
            }
        }

        private void validateAddPackages(List<AddPackage> list) {
            for (AddPackage add : list) {
                Objects.requireNonNull(add);
            }
        }

        Builder exports(List<AddPackage> exports) {
            this.validateAddPackages(exports);
            this.addExports.addAll(exports);
            return this;
        }

        Builder opens(List<AddPackage> opens) {
            this.validateAddPackages(opens);
            this.addOpens.addAll(opens);
            return this;
        }

        Builder reads(List<String> reads) {
            this.validateAddReads(reads);
            this.addReads.addAll(reads);
            return this;
        }

        FileMetadata build() {
            if (this.path == null && this.uri != null) {
                this.path(FileUtils.fromUri(this.uri));
            }
            if (this.uri == null && this.path != null) {
                this.uri(FileUtils.fromPath(this.path));
            }
            if (this.uri != null && !this.uri.isAbsolute() && this.uri.getPath().startsWith("/")) {
                this.uri = URI.create("/").relativize(this.uri);
            }
            if (this.path != null && !this.path.isAbsolute() && this.path.startsWith("/")) {
                this.path = Paths.get("/", new String[0]).relativize(this.path);
            }
            if (this.baseUri != null && this.uri != null) {
                this.uri = this.baseUri.resolve(this.uri);
            }
            if (this.basePath != null && this.path != null) {
                this.path = this.basePath.resolve(this.path);
            }
            return new FileMetadata(this.uri, this.path, this.os, this.checksum, this.size, this.classpath, this.modulepath, this.comment, this.ignoreBootConflict, this.signature, this.addExports, this.addOpens, this.addReads, null);
        }
    }

    public static class Reference {
        private Path source;
        private String path;
        private String uri;
        private OS os;
        private Boolean classpath;
        private Boolean modulepath;
        private String comment;
        private Boolean ignoreBootConflict;
        private List<AddPackage> addExports;
        private List<AddPackage> addOpens;
        private List<String> addReads;
        private PlaceholderMatchType matcher;

        private Reference(Path source) {
            this.source = source;
            this.addExports = new ArrayList<AddPackage>();
            this.addOpens = new ArrayList<AddPackage>();
            this.addReads = new ArrayList<String>();
        }

        public Path getSource() {
            return this.source;
        }

        public Reference uri(URI uri) {
            return this.uri(uri == null ? null : uri.toString());
        }

        public Reference uri(String uri) {
            this.uri = uri;
            return this;
        }

        public String getUri() {
            return this.uri;
        }

        public Reference path(Path path) {
            return this.path(path == null ? null : path.toString());
        }

        public Reference path(String path) {
            this.path = path;
            return this;
        }

        String getPath() {
            return this.path;
        }

        public Reference os(OS os) {
            this.os = os;
            return this;
        }

        public Reference osFromFilename() {
            OS os = FileUtils.fromFilename(this.source.toString());
            if (os != null) {
                this.os(os);
            }
            return this;
        }

        public OS getOs() {
            return this.os;
        }

        public Reference classpath(boolean cp) {
            this.classpath = cp;
            return this;
        }

        public Reference classpath() {
            return this.classpath(true);
        }

        public boolean isClasspath() {
            return Boolean.TRUE.equals(this.classpath);
        }

        public Reference modulepath(boolean mp) {
            this.modulepath = mp;
            return this;
        }

        public Reference modulepath() {
            return this.modulepath(true);
        }

        public boolean isModulepath() {
            return Boolean.TRUE.equals(this.modulepath);
        }

        private boolean isFinalModulepath() throws IOException {
            if (!this.isModulepath()) {
                return false;
            }
            return FileUtils.isZipFile(this.getSource());
        }

        public Reference comment(String c) {
            this.comment = c;
            return this;
        }

        public String getComment() {
            return this.comment;
        }

        public Reference ignoreBootConflict(boolean b) {
            this.ignoreBootConflict = b;
            return this;
        }

        public Reference ignoreBootConflict() {
            return this.ignoreBootConflict(true);
        }

        public boolean isIgnoreBootConflict() {
            return Boolean.TRUE.equals(this.ignoreBootConflict);
        }

        public Reference exports(String pkg, String targetModule) {
            this.addExports.add(new AddPackage(Objects.requireNonNull(pkg), Objects.requireNonNull(targetModule)));
            return this;
        }

        public Reference exports(Collection<AddPackage> exports) {
            this.addExports.addAll(exports);
            return this;
        }

        public List<AddPackage> getAddExports() {
            return this.addExports;
        }

        public Reference opens(String pkg, String targetModule) {
            this.addOpens.add(new AddPackage(pkg, targetModule));
            return this;
        }

        public Reference opens(Collection<AddPackage> opens) {
            this.addOpens.addAll(opens);
            return this;
        }

        public List<AddPackage> getAddOpens() {
            return this.addOpens;
        }

        public Reference reads(String module) {
            this.addReads.add(module);
            return this;
        }

        public Reference reads(Collection<String> reads) {
            this.addReads.addAll(reads);
            return this;
        }

        public List<String> getAddReads() {
            return this.addReads;
        }

        public Reference matchAndReplace(PlaceholderMatchType matcher) {
            this.matcher = matcher;
            return this;
        }

        public PlaceholderMatchType getMatchType() {
            return this.matcher;
        }

        public long getSize() throws IOException {
            return Files.size(this.source);
        }

        public long getChecksum() throws IOException {
            return FileUtils.getChecksum(this.source);
        }

        public byte[] getSignature(PrivateKey key) throws IOException {
            if (key == null) {
                return null;
            }
            return FileUtils.sign(this.source, key);
        }

        FileMapper getFileMapper(PropertyManager pm, String baseUri, String basePath, PlaceholderMatchType matchType, PrivateKey key) {
            try {
                PlaceholderMatchType matcher;
                String path = this.getPath();
                if (this.uri == null && this.getPath() == null) {
                    path = this.source.toString();
                }
                if (this.uri != null) {
                    this.uri = this.uri.replace("\\", "/");
                }
                if (path != null) {
                    path = path.replace("\\", "/");
                }
                if (this.uri != null && this.uri.equals(path)) {
                    this.uri = null;
                }
                if ((matcher = this.getMatchType()) == null) {
                    matcher = matchType;
                }
                FileMapper mapper = new FileMapper();
                mapper.uri = pm.implyPlaceholders(this.getUri(), matcher, true);
                mapper.path = pm.implyPlaceholders(path, matcher, true);
                String phBaseUri = pm.implyPlaceholders(baseUri, matcher, true);
                if (mapper.uri != null && phBaseUri != null && mapper.uri.startsWith(phBaseUri)) {
                    mapper.uri = mapper.uri.substring(phBaseUri.length());
                }
                String phBasePath = pm.implyPlaceholders(basePath, matcher, true);
                if (mapper.path != null && phBasePath != null && mapper.path.startsWith(phBasePath)) {
                    mapper.path = mapper.path.substring(phBasePath.length());
                }
                mapper.os = this.getOs();
                mapper.size = this.getSize();
                mapper.checksum = Long.toHexString(this.getChecksum());
                mapper.classpath = this.isClasspath();
                mapper.modulepath = this.isFinalModulepath();
                mapper.ignoreBootConflict = this.isIgnoreBootConflict();
                byte[] sig = this.getSignature(key);
                if (sig != null) {
                    mapper.signature = Base64.getEncoder().encodeToString(sig);
                }
                mapper.comment = pm.implyPlaceholders(this.getComment(), matcher, false);
                mapper.addExports.addAll(this.getAddExports());
                mapper.addOpens.addAll(this.getAddOpens());
                mapper.addReads.addAll(this.getAddReads());
                return mapper;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

