/*
 * Decompiled with CFR 0.152.
 */
package org.update4j;

import java.util.Locale;

public enum OS {
    WINDOWS("win"),
    MAC("mac"),
    LINUX("linux"),
    OTHER("other");

    public static final OS CURRENT;
    private String name;

    static {
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ROOT);
        CURRENT = os.contains("mac") || os.contains("darwin") ? MAC : (os.contains("win") ? WINDOWS : (os.contains("nux") ? LINUX : OTHER));
    }

    private OS(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.name;
    }

    public static OS fromShortName(String name) {
        switch (name) {
            case "win": {
                return WINDOWS;
            }
            case "mac": {
                return MAC;
            }
            case "linux": {
                return LINUX;
            }
            case "other": {
                return OTHER;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + name);
    }
}

