/*
 * Decompiled with CFR 0.152.
 */
package org.update4j;

import java.util.Objects;
import org.update4j.OS;

public class Property {
    private String key;
    private String value;
    private OS os;

    public Property(String key, String value, OS os) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key must not be empty.");
        }
        if (key.contains("$")) {
            throw new IllegalArgumentException("Key contains illegal character '$': " + key);
        }
        if (key.contains("{")) {
            throw new IllegalArgumentException("Key contains illegal character '{': " + key);
        }
        if (key.contains("}")) {
            throw new IllegalArgumentException("Key contains illegal character '}': " + key);
        }
        this.key = key;
        this.value = Objects.requireNonNull(value);
        this.os = os;
    }

    public Property(String key, String value) {
        this(key, value, null);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public OS getOs() {
        return this.os;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.os != other.os) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

