/*
 * Decompiled with CFR 0.152.
 */
package org.update4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.update4j.SingleInstanceException;
import org.update4j.util.FileUtils;

public class SingleInstanceManager {
    private SingleInstanceManager() {
    }

    public static void execute() {
        SingleInstanceManager.execute(null);
    }

    public static void execute(Path lockFileDir) {
        SingleInstanceManager.execute(null, null, lockFileDir);
    }

    public static void execute(List<String> args, Consumer<? super List<String>> onNewInstance) {
        SingleInstanceManager.execute(args, onNewInstance, null);
    }

    public static void execute(List<String> args, Consumer<? super List<String>> onNewInstance, Path lockFileDir) {
        try {
            SingleInstanceManager.tryExecute(args, onNewInstance, lockFileDir);
        }
        catch (SingleInstanceException e) {
            System.exit(1);
        }
    }

    public static void tryExecute() throws SingleInstanceException {
        SingleInstanceManager.tryExecute(null);
    }

    public static void tryExecute(Path lockFileDir) throws SingleInstanceException {
        SingleInstanceManager.tryExecute(null, null, lockFileDir);
    }

    public static void tryExecute(List<String> args, Consumer<? super List<String>> onNewInstance) throws SingleInstanceException {
        SingleInstanceManager.tryExecute(args, onNewInstance, null);
    }

    public static void tryExecute(List<String> args, Consumer<? super List<String>> onNewInstance, Path lockFileDir) throws SingleInstanceException {
        block45: {
            if (args == null) {
                args = List.of();
            }
            if (lockFileDir == null) {
                lockFileDir = Paths.get(System.getProperty("user.dir"), new String[0]);
            }
            final Path lockFile = lockFileDir.resolve(".lock");
            final Path portFile = lockFileDir.resolve(".port");
            try {
                final RandomAccessFile randomAccess = new RandomAccessFile(lockFile.toFile(), "rw");
                final FileLock lock = randomAccess.getChannel().tryLock();
                if (lock != null) {
                    FileUtils.windowsHidden(lockFile, true);
                    final ServerSocket server = new ServerSocket(0, 0, InetAddress.getByName(null));
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                lock.release();
                                server.close();
                                randomAccess.close();
                                Files.delete(lockFile);
                                Files.delete(portFile);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    Throwable throwable = null;
                    Object var9_16 = null;
                    try (BufferedWriter out = Files.newBufferedWriter(portFile, StandardOpenOption.CREATE);){
                        out.write("" + server.getLocalPort());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    FileUtils.windowsHidden(portFile, false);
                    Thread listen = new Thread(() -> {
                        while (!server.isClosed()) {
                            try {
                                Throwable throwable = null;
                                Object var3_6 = null;
                                try {
                                    Socket socket = server.accept();
                                    try {
                                        try (BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                                            List input = in.lines().collect(Collectors.toList());
                                            if (onNewInstance != null) {
                                                onNewInstance.accept(input);
                                            }
                                        }
                                        if (socket == null) continue;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (socket != null) {
                                            socket.close();
                                        }
                                        throw throwable;
                                    }
                                    socket.close();
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (SocketException e) {
                                if (server.isClosed()) continue;
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }, "Instance Message Dispatcher");
                    listen.setDaemon(true);
                    listen.start();
                    break block45;
                }
                try {
                    Throwable server = null;
                    Object var8_14 = null;
                    try (BufferedReader in = Files.newBufferedReader(portFile);){
                        randomAccess.close();
                        int port = Integer.parseInt(in.readLine());
                        Throwable throwable = null;
                        Object var12_23 = null;
                        try (Socket signal = new Socket("localhost", port);){
                            signal.setSoTimeout(1000);
                            Throwable throwable3 = null;
                            Object var15_28 = null;
                            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(signal.getOutputStream()));){
                                for (String s : args) {
                                    out.write(String.valueOf(s) + "\n");
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        if (server == null) {
                            server = throwable;
                        } else if (server != throwable) {
                            server.addSuppressed(throwable);
                        }
                        throw server;
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                throw new SingleInstanceException();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

