/*
 * Decompiled with CFR 0.152.
 */
package org.update4j;

import java.nio.file.Path;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.update4j.Configuration;
import org.update4j.FileMetadata;

public class UpdateContext {
    private Configuration configuration;
    private List<FileMetadata> requiresUpdate;
    private List<FileMetadata> updated;
    private Path tempDir;
    private Path archive;
    private PublicKey key;

    UpdateContext(Configuration config, List<FileMetadata> requiresUpdate, List<FileMetadata> updated, Path tempDir, PublicKey key, Path archive) {
        this.configuration = Objects.requireNonNull(config);
        this.requiresUpdate = Collections.unmodifiableList(requiresUpdate);
        this.updated = Collections.unmodifiableList(updated);
        this.tempDir = tempDir;
        this.key = key;
        this.archive = archive;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public List<FileMetadata> getRequiresUpdate() {
        return this.requiresUpdate;
    }

    public List<FileMetadata> getUpdated() {
        return this.updated;
    }

    @Deprecated
    public Path getTempDirectory() {
        return this.tempDir;
    }

    public PublicKey getPublicKey() {
        return this.key;
    }

    public Path getArchiveLocation() {
        return this.archive;
    }
}

