/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.inject;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.update4j.inject.InjectSource;
import org.update4j.inject.InjectTarget;
import org.update4j.inject.PostInject;
import org.update4j.inject.UnsatisfiedInjectionException;

public interface Injectable {
    public static void injectBidirectional(Injectable obj1, Injectable obj2) throws UnsatisfiedInjectionException, IllegalAccessException, InvocationTargetException {
        Map<String, Object> sources1 = Injectable.getSourceObjects(obj1);
        Map<String, Object> sources2 = Injectable.getSourceObjects(obj2);
        Injectable.injectValues(obj2, sources1);
        Injectable.injectValues(obj1, sources2);
        Injectable.notifyPostInject(obj1, obj2);
        Injectable.notifyPostInject(obj2, obj1);
    }

    public static void injectUnidirectional(Injectable source, Injectable target) throws IllegalAccessException, UnsatisfiedInjectionException, InvocationTargetException {
        Map<String, Object> sourceObjects = Injectable.getSourceObjects(source);
        Injectable.injectValues(target, sourceObjects);
        Injectable.notifyPostInject(source, target);
        Injectable.notifyPostInject(target, source);
    }

    private static Map<String, Object> getSourceObjects(Injectable obj) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fieldArray = obj.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            InjectSource annotation = f.getAnnotation(InjectSource.class);
            if (annotation != null) {
                String key = annotation.target();
                String string = key = key.isEmpty() ? f.getName() : key;
                if (map.containsKey(key)) {
                    throw new IllegalArgumentException("Two fields with '" + key + "' target.");
                }
                f.setAccessible(true);
                Object value = f.get(obj);
                map.put(key, value);
            }
            ++n2;
        }
        return map;
    }

    private static void injectValues(Injectable obj, Map<String, Object> map) throws UnsatisfiedInjectionException, IllegalAccessException {
        Field[] fieldArray = obj.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            InjectTarget annotation = f.getAnnotation(InjectTarget.class);
            if (annotation != null) {
                if (!map.containsKey(f.getName())) {
                    if (annotation.required()) {
                        throw new UnsatisfiedInjectionException(f);
                    }
                } else {
                    Object value = map.get(f.getName());
                    f.setAccessible(true);
                    f.set(obj, value);
                }
            }
            ++n2;
        }
    }

    private static void notifyPostInject(Injectable callback, Injectable parameter) throws IllegalAccessException, InvocationTargetException {
        Method[] methodArray = callback.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            PostInject annotation = m.getAnnotation(PostInject.class);
            if (annotation != null) {
                m.setAccessible(true);
                Object[] params = new Object[m.getParameterCount()];
                if (m.getParameterCount() > 0 && m.getParameterTypes()[0].isInstance(parameter)) {
                    params[0] = parameter;
                }
                m.invoke((Object)callback, params);
            }
            ++n2;
        }
    }
}

