/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.mapper;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.update4j.OS;
import org.update4j.Property;
import org.update4j.mapper.FileMapper;
import org.update4j.mapper.XmlMapper;
import org.update4j.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigMapper
extends XmlMapper {
    public String timestamp;
    public String signature;
    public String baseUri;
    public String basePath;
    public String updateHandler;
    public String launcher;
    public final List<Property> properties = new ArrayList<Property>();
    public final List<FileMapper> files = new ArrayList<FileMapper>();

    public ConfigMapper() {
    }

    public ConfigMapper(Node node) {
        this();
        this.parse(node);
    }

    public ConfigMapper(ConfigMapper copy) {
        this();
        this.timestamp = copy.timestamp;
        this.signature = copy.signature;
        this.baseUri = copy.baseUri;
        this.basePath = copy.basePath;
        this.updateHandler = copy.updateHandler;
        this.launcher = copy.launcher;
        this.properties.addAll(copy.properties);
        this.files.addAll(copy.files.stream().map(FileMapper::new).collect(Collectors.toList()));
    }

    @Override
    public void parse(Node node) {
        if (!"configuration".equals(node.getNodeName())) {
            return;
        }
        this.timestamp = ConfigMapper.getAttributeValue(node, "timestamp");
        this.signature = ConfigMapper.getAttributeValue(node, "signature");
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if ("base".equals(n.getNodeName())) {
                this.baseUri = ConfigMapper.getAttributeValue(n, "uri");
                this.basePath = ConfigMapper.getAttributeValue(n, "path");
            } else if ("provider".equals(n.getNodeName())) {
                this.updateHandler = ConfigMapper.getAttributeValue(n, "updateHandler");
                this.launcher = ConfigMapper.getAttributeValue(n, "launcher");
            } else if ("properties".equals(n.getNodeName())) {
                this.parseProperties(n.getChildNodes());
            } else if ("files".equals(n.getNodeName())) {
                this.parseFiles(n.getChildNodes());
            }
            ++i;
        }
    }

    private void parseProperties(NodeList list) {
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if ("property".equals(n.getNodeName())) {
                String key = ConfigMapper.getAttributeValue(n, "key");
                String value = ConfigMapper.getAttributeValue(n, "value");
                String os = ConfigMapper.getAttributeValue(n, "os");
                OS osEnum = null;
                if (os != null) {
                    osEnum = OS.fromShortName(os);
                }
                if (key != null && value != null) {
                    this.properties.add(new Property(key, value, osEnum));
                }
            }
            ++i;
        }
    }

    private void parseFiles(NodeList list) {
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if ("file".equals(n.getNodeName())) {
                this.files.add(new FileMapper(n));
            }
            ++i;
        }
    }

    @Override
    public String toXml() {
        String children;
        StringBuilder builder = new StringBuilder();
        builder.append("<configuration");
        if (this.timestamp != null) {
            builder.append(" timestamp=\"" + ConfigMapper.escape(this.timestamp) + "\"");
        }
        if (this.signature != null) {
            builder.append(" signature=\"" + ConfigMapper.escape(this.signature) + "\"");
        }
        if (!(children = this.getChildrenXml()).isEmpty()) {
            builder.append(">\n");
            builder.append(children);
            builder.append("</configuration>");
        } else {
            builder.append("/>\n");
        }
        return builder.toString();
    }

    private String getChildrenXml() {
        if (this.baseUri == null && this.basePath == null && this.updateHandler == null && this.launcher == null && this.properties.isEmpty() && this.files.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (this.baseUri != null || this.basePath != null) {
            builder.append("    <base");
            if (this.baseUri != null) {
                builder.append(" uri=\"" + ConfigMapper.escape(this.baseUri) + "\"");
            }
            if (this.basePath != null) {
                builder.append(" path=\"" + ConfigMapper.escape(this.basePath) + "\"");
            }
            builder.append("/>\n");
        }
        if (this.updateHandler != null || this.launcher != null) {
            builder.append("    <provider");
            if (this.updateHandler != null) {
                builder.append(" updateHandler=\"" + ConfigMapper.escape(this.updateHandler) + "\"");
            }
            if (this.launcher != null) {
                builder.append(" launcher=\"" + ConfigMapper.escape(this.launcher) + "\"");
            }
            builder.append("/>\n");
        }
        if (!this.properties.isEmpty()) {
            builder.append("    <properties>\n");
            for (Property p : this.properties) {
                builder.append("        <property");
                builder.append(" key=\"" + ConfigMapper.escape(p.getKey()) + "\"");
                builder.append(" value=\"" + ConfigMapper.escape(p.getValue()) + "\"");
                if (p.getOs() != null) {
                    builder.append(" os=\"" + p.getOs().getShortName() + "\"");
                }
                builder.append("/>\n");
            }
            builder.append("    </properties>\n");
        }
        if (!this.files.isEmpty()) {
            builder.append("    <files>\n");
            for (FileMapper fm : this.files) {
                builder.append(fm.toXml());
            }
            builder.append("    </files>\n");
        }
        return builder.toString();
    }

    public String sign(PrivateKey key) {
        try {
            Signature sign = FileUtils.getSignature(key);
            sign.initSign(key);
            sign.update(this.getChildrenXml().getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(sign.sign());
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public void verifySignature(PublicKey key) {
        if (this.signature == null) {
            throw new SecurityException("No signature in configuration root node.");
        }
        try {
            Signature sign = FileUtils.getSignature(key);
            sign.initVerify(key);
            sign.update(this.getChildrenXml().getBytes(StandardCharsets.UTF_8));
            if (!sign.verify(Base64.getDecoder().decode(this.signature))) {
                throw new SecurityException("Signature verification failed.");
            }
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new SecurityException(e);
        }
    }

    public static ConfigMapper read(Reader reader) throws IOException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(reader));
            NodeList list = doc.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                if ("configuration".equals(n.getNodeName())) {
                    return new ConfigMapper(n);
                }
                ++i;
            }
            throw new IllegalStateException("Root element must be 'configuration'.");
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, true);
    }

    public void write(Writer writer, boolean header) throws IOException {
        if (header) {
            writer.write("<?xml version=\"1.1\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            writer.write("\n");
            writer.write("<!-- Generated by update4j. Licensed under Apache Software License 2.0 -->\n");
        }
        writer.write(this.toXml());
    }
}

