/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.mapper;

import java.io.IOException;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import org.update4j.AddPackage;
import org.update4j.OS;
import org.update4j.mapper.XmlMapper;
import org.update4j.util.FileUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileMapper
extends XmlMapper {
    public String uri;
    public String path;
    public String checksum;
    public Long size;
    public OS os;
    public Boolean classpath;
    public Boolean modulepath;
    public String comment;
    public Boolean ignoreBootConflict;
    public String signature;
    public final List<AddPackage> addExports = new ArrayList<AddPackage>();
    public final List<AddPackage> addOpens = new ArrayList<AddPackage>();
    public final List<String> addReads = new ArrayList<String>();

    public FileMapper() {
    }

    public FileMapper(Node node) {
        this();
        this.parse(node);
    }

    public FileMapper(FileMapper copy) {
        this();
        this.uri = copy.uri;
        this.path = copy.path;
        this.checksum = copy.checksum;
        this.size = copy.size;
        this.os = copy.os;
        this.classpath = copy.classpath;
        this.modulepath = copy.modulepath;
        this.comment = copy.comment;
        this.ignoreBootConflict = copy.ignoreBootConflict;
        this.signature = copy.signature;
        this.addExports.addAll(copy.addExports);
        this.addOpens.addAll(copy.addOpens);
        this.addReads.addAll(copy.addReads);
    }

    @Override
    public void parse(Node node) {
        String modulepath;
        String classpath;
        String os;
        if (!"file".equals(node.getNodeName())) {
            return;
        }
        this.uri = FileMapper.getAttributeValue(node, "uri");
        this.path = FileMapper.getAttributeValue(node, "path");
        this.checksum = FileMapper.getAttributeValue(node, "checksum");
        String size = FileMapper.getAttributeValue(node, "size");
        if (size != null) {
            this.size = Long.parseLong(size);
        }
        if ((os = FileMapper.getAttributeValue(node, "os")) != null) {
            this.os = OS.fromShortName(os);
        }
        if ((classpath = FileMapper.getAttributeValue(node, "classpath")) != null) {
            this.classpath = Boolean.parseBoolean(classpath);
        }
        if ((modulepath = FileMapper.getAttributeValue(node, "modulepath")) != null) {
            this.modulepath = Boolean.parseBoolean(modulepath);
        }
        this.comment = FileMapper.getAttributeValue(node, "comment");
        String ignoreBootConflict = FileMapper.getAttributeValue(node, "ignoreBootConflict");
        if (ignoreBootConflict != null) {
            this.ignoreBootConflict = Boolean.parseBoolean(ignoreBootConflict);
        }
        this.signature = FileMapper.getAttributeValue(node, "signature");
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if ("addExports".equals(n.getNodeName())) {
                this.parseExports(n.getChildNodes());
            } else if ("addOpens".equals(n.getNodeName())) {
                this.parseOpens(n.getChildNodes());
            } else if ("addReads".equals(n.getNodeName())) {
                this.parseReads(n.getChildNodes());
            }
            ++i;
        }
    }

    private void parseExports(NodeList list) {
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if ("exports".equals(n.getNodeName())) {
                String packageName = FileMapper.getAttributeValue(n, "package");
                String targetModule = FileMapper.getAttributeValue(n, "target");
                if (packageName != null && targetModule != null) {
                    this.addExports.add(new AddPackage(packageName, targetModule));
                }
            }
            ++i;
        }
    }

    private void parseOpens(NodeList list) {
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if ("opens".equals(n.getNodeName())) {
                String packageName = FileMapper.getAttributeValue(n, "package");
                String targetModule = FileMapper.getAttributeValue(n, "target");
                if (packageName != null && targetModule != null) {
                    this.addOpens.add(new AddPackage(packageName, targetModule));
                }
            }
            ++i;
        }
    }

    private void parseReads(NodeList list) {
        int i = 0;
        while (i < list.getLength()) {
            String module;
            Node n = list.item(i);
            if ("reads".equals(n.getNodeName()) && (module = FileMapper.getAttributeValue(n, "module")) != null) {
                this.addReads.add(module);
            }
            ++i;
        }
    }

    @Override
    public String toXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("        <file");
        if (this.uri != null) {
            builder.append(" uri=\"" + FileMapper.escape(this.uri) + "\"");
        }
        if (this.path != null) {
            builder.append(" path=\"" + FileMapper.escape(this.path) + "\"");
        }
        if (this.size != null) {
            builder.append(" size=\"" + this.size + "\"");
        }
        if (this.checksum != null) {
            builder.append(" checksum=\"" + FileMapper.escape(this.checksum) + "\"");
        }
        if (this.os != null) {
            builder.append(" os=\"" + this.os.getShortName() + "\"");
        }
        if (this.classpath != null && this.classpath.booleanValue()) {
            builder.append(" classpath=\"true\"");
        }
        if (this.modulepath != null && this.modulepath.booleanValue()) {
            builder.append(" modulepath=\"true\"");
        }
        if (this.comment != null) {
            builder.append(" comment=\"" + FileMapper.escape(this.comment) + "\"");
        }
        if (this.ignoreBootConflict != null && this.ignoreBootConflict.booleanValue()) {
            builder.append(" ignoreBootConflict=\"true\"");
        }
        if (this.signature != null) {
            builder.append(" signature=\"" + FileMapper.escape(this.signature) + "\"");
        }
        if (!(this.addExports.isEmpty() && this.addOpens.isEmpty() && this.addReads.isEmpty())) {
            builder.append(">\n");
            if (!this.addExports.isEmpty()) {
                builder.append("            <addExports>\n");
                for (AddPackage ap : this.addExports) {
                    builder.append("                <exports");
                    builder.append(" package=\"" + FileMapper.escape(ap.getPackageName()) + "\"");
                    builder.append(" target=\"" + FileMapper.escape(ap.getTargetModule()) + "\"/>\n");
                }
                builder.append("            </addExports>\n");
            }
            if (!this.addOpens.isEmpty()) {
                builder.append("            <addOpens>\n");
                for (AddPackage ap : this.addOpens) {
                    builder.append("                <opens");
                    builder.append(" package=\"" + FileMapper.escape(ap.getPackageName()) + "\"");
                    builder.append(" target=\"" + FileMapper.escape(ap.getTargetModule()) + "\"/>\n");
                }
                builder.append("            </addOpens>\n");
            }
            if (!this.addReads.isEmpty()) {
                builder.append("            <addReads>\n");
                for (String r : this.addReads) {
                    builder.append("                <reads");
                    builder.append(" module=\"" + FileMapper.escape(r) + "\"/>\n");
                }
                builder.append("            </addReads>\n");
            }
            builder.append("        </file>\n");
        } else {
            builder.append("/>\n");
        }
        return builder.toString();
    }

    public static long getChecksum(Path path) throws IOException {
        return FileUtils.getChecksum(path);
    }

    public static String getChecksumHex(Path path) throws IOException {
        return FileUtils.getChecksumString(path);
    }

    public static byte[] getSignature(Path path, PrivateKey key) throws IOException {
        return FileUtils.sign(path, key);
    }

    public static String getSignatureEncoded(Path path, PrivateKey key) throws IOException {
        return FileUtils.signAndEncode(path, key);
    }
}

