/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.mapper;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.update4j.mapper.XmlMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MapMapper
extends XmlMapper {
    private Map<String, String> map;
    private String name;

    private MapMapper(Map<String, String> map, String name) {
        this.map = map;
        this.name = name;
    }

    private MapMapper(Node node, String name) {
        this.map = new HashMap<String, String>();
        this.name = name;
        this.parse(node);
    }

    @Override
    public void parse(Node node) {
        if (!node.getNodeName().equals(this.name)) {
            return;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if ("item".equals(n.getNodeName())) {
                String key = MapMapper.getAttributeValue(n, "key");
                String value = MapMapper.getAttributeValue(n, "value");
                if (key != null && value != null) {
                    this.map.put(key, value);
                }
            }
            ++i;
        }
    }

    @Override
    public String toXml() {
        if (this.map.isEmpty()) {
            return "<" + this.name + "/>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<" + this.name + ">\n");
        for (Map.Entry<String, String> item : this.map.entrySet()) {
            if (item.getKey() == null || item.getValue() == null) continue;
            builder.append("    <item key=\"" + MapMapper.escape(item.getKey()) + "\" value=\"" + MapMapper.escape(item.getValue()) + "\"/>\n");
        }
        builder.append("</" + this.name + ">");
        return builder.toString();
    }

    public static Map<String, String> read(Reader reader) throws IOException {
        return MapMapper.read(reader, "map");
    }

    public static Map<String, String> read(Reader reader, String name) throws IOException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(reader));
            NodeList list = doc.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                if (n.getNodeName().equals(name)) {
                    return new MapMapper((Node)n, (String)name).map;
                }
                ++i;
            }
            throw new IllegalStateException("Root element must be '" + name + "'.");
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    public static void write(Writer writer, Map<String, String> map) throws IOException {
        MapMapper.write(writer, map, "map");
    }

    public static void write(Writer writer, Map<String, String> map, String name) throws IOException {
        MapMapper mapper = new MapMapper(map, name);
        writer.write(mapper.toXml());
    }
}

