/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.util.List;
import java.util.Map;
import org.update4j.Archive;
import org.update4j.Configuration;
import org.update4j.SingleInstanceManager;
import org.update4j.UpdateOptions;
import org.update4j.inject.InjectSource;
import org.update4j.service.Delegate;
import org.update4j.util.ArgUtils;

public class DefaultBootstrap
implements Delegate {
    private static final String OLD_CONFIG = "config.old";
    private String remote;
    private String local;
    private String archivePath = "./update.zip";
    private String cert;
    private boolean syncLocal;
    private boolean launchFirst;
    private boolean stopOnUpdateError;
    private boolean singleInstance;
    private PublicKey pk = null;
    @InjectSource(target="args")
    private List<String> businessArgs;

    @Override
    public long version() {
        return Long.MIN_VALUE;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getLocal() {
        return this.local;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public String getCert() {
        return this.cert;
    }

    public boolean isSyncLocal() {
        return this.syncLocal;
    }

    public boolean isLaunchFirst() {
        return this.launchFirst;
    }

    public boolean isStopOnUpdateError() {
        return this.stopOnUpdateError;
    }

    public boolean isSingleInstance() {
        return this.singleInstance;
    }

    public PublicKey getPublicKey() {
        return this.pk;
    }

    public List<String> getBusinessArgs() {
        return this.businessArgs;
    }

    @Override
    public void main(List<String> args) throws Throwable {
        if (args.isEmpty()) {
            DefaultBootstrap.welcome();
            return;
        }
        this.parseArgs(ArgUtils.beforeSeparator(args));
        if (this.remote == null && this.local == null) {
            throw new IllegalArgumentException("One of --remote or --local must be supplied.");
        }
        if (this.launchFirst && this.local == null) {
            throw new IllegalArgumentException("--launchFirst requires a local configuration.");
        }
        if (this.syncLocal && this.remote == null) {
            throw new IllegalArgumentException("--syncLocal requires a remote configuration.");
        }
        if (this.syncLocal && this.local == null) {
            throw new IllegalArgumentException("--syncLocal requires a local configuration.");
        }
        if (this.singleInstance) {
            SingleInstanceManager.execute();
        }
        if (this.cert != null) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream in = Files.newInputStream(Paths.get(this.cert, new String[0]), new OpenOption[0]);){
                this.pk = cf.generateCertificate(in).getPublicKey();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.businessArgs = ArgUtils.afterSeparator(args);
        if (this.launchFirst) {
            this.launchFirst();
        } else {
            this.updateFirst();
        }
    }

    protected void parseArgs(List<String> bootArgs) {
        Map<String, String> parsed = ArgUtils.parseArgs(bootArgs);
        for (Map.Entry<String, String> e : parsed.entrySet()) {
            String arg = e.getKey();
            if ("syncLocal".equals(arg)) {
                ArgUtils.validateNoValue(e);
                this.syncLocal = true;
                continue;
            }
            if ("launchFirst".equals(arg)) {
                ArgUtils.validateNoValue(e);
                this.launchFirst = true;
                continue;
            }
            if ("stopOnUpdateError".equals(arg)) {
                ArgUtils.validateNoValue(e);
                this.stopOnUpdateError = true;
                continue;
            }
            if ("singleInstance".equals(arg)) {
                ArgUtils.validateNoValue(e);
                this.singleInstance = true;
                continue;
            }
            if ("remote".equals(arg)) {
                ArgUtils.validateHasValue(e);
                this.remote = e.getValue();
                continue;
            }
            if ("local".equals(arg)) {
                ArgUtils.validateHasValue(e);
                this.local = e.getValue();
                continue;
            }
            if ("cert".equals(arg)) {
                ArgUtils.validateHasValue(e);
                this.cert = e.getValue();
                continue;
            }
            if ("archive".equals(arg)) {
                ArgUtils.validateHasValue(e);
                this.archivePath = e.getValue();
                continue;
            }
            if ("delegate".equals(arg)) {
                throw new IllegalArgumentException("--delegate must be passed as first argument.");
            }
            throw new IllegalArgumentException("Unknown option \"" + arg + "\". Separate business app arguments with '--'.");
        }
    }

    protected void updateFirst() throws Throwable {
        boolean success;
        Configuration remoteConfig = null;
        Configuration localConfig = null;
        if (this.remote != null) {
            remoteConfig = this.getRemoteConfig();
        }
        if (this.local != null) {
            localConfig = this.getLocalConfig(remoteConfig != null && this.syncLocal);
        }
        if (remoteConfig == null && localConfig == null) {
            return;
        }
        Configuration config = remoteConfig != null ? remoteConfig : localConfig;
        Path zip = Paths.get(this.archivePath, new String[0]);
        boolean bl = success = config.update((UpdateOptions.ArchiveUpdateOptions)UpdateOptions.archive(zip).publicKey(this.pk)).getException() == null;
        if (!success && this.stopOnUpdateError) {
            return;
        }
        if (Files.exists(zip, new LinkOption[0])) {
            Archive.read(zip).install();
        }
        if (success && this.syncLocal && config == remoteConfig) {
            this.syncLocal(remoteConfig);
            if (localConfig != null && !localConfig.equals(remoteConfig)) {
                remoteConfig.deleteOldFiles(localConfig);
            }
        }
        config.launch(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void launchFirst() throws Throwable {
        boolean success;
        Configuration remoteConfig;
        block36: {
            Configuration localConfig;
            Throwable throwable;
            Path zip = Paths.get(this.archivePath, new String[0]);
            if (Files.exists(zip, new LinkOption[0])) {
                try {
                    Configuration newConfig;
                    Configuration oldConfig;
                    Archive archive;
                    block34: {
                        archive = Archive.read(zip);
                        oldConfig = null;
                        newConfig = archive.getConfiguration();
                        Throwable throwable2 = null;
                        throwable = null;
                        try (FileSystem fs = archive.openConnection();){
                            Path oldPath = fs.getPath(OLD_CONFIG, new String[0]);
                            if (!Files.exists(oldPath, new LinkOption[0])) break block34;
                            Throwable throwable3 = null;
                            Object var10_18 = null;
                            try (BufferedReader in = Files.newBufferedReader(oldPath);){
                                oldConfig = Configuration.read(in);
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                    throw throwable3;
                                }
                                if (throwable3 == throwable4) throw throwable3;
                                throwable3.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                                throw throwable2;
                            }
                            if (throwable2 == throwable5) throw throwable2;
                            throwable2.addSuppressed(throwable5);
                            throw throwable2;
                        }
                    }
                    archive.install();
                    newConfig.deleteOldFiles(oldConfig);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((localConfig = this.getLocalConfig(false)) != null && !localConfig.requiresUpdate()) {
                Configuration finalConfig = localConfig;
                Thread localApp = new Thread(() -> finalConfig.launch(this));
                localApp.start();
                if (this.remote == null) {
                    return;
                }
            } else {
                this.syncLocal = true;
                this.updateFirst();
                return;
            }
            remoteConfig = this.getRemoteConfig();
            if (remoteConfig.equals(localConfig)) {
                return;
            }
            boolean bl = success = remoteConfig.update((UpdateOptions.ArchiveUpdateOptions)UpdateOptions.archive(zip).publicKey(this.pk)).getException() == null;
            if (Files.exists(zip, new LinkOption[0])) {
                Archive archive = Archive.read(zip);
                throwable = null;
                Object var7_12 = null;
                try {
                    FileSystem fs = archive.openConnection();
                    try {
                        try (BufferedWriter out = Files.newBufferedWriter(fs.getPath(OLD_CONFIG, new String[0]), new OpenOption[0]);){
                            localConfig.write(out);
                        }
                        if (fs == null) break block36;
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        if (fs == null) throw throwable;
                        fs.close();
                        throw throwable;
                    }
                    fs.close();
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        throwable = throwable7;
                        throw throwable;
                    }
                    if (throwable == throwable7) throw throwable;
                    throwable.addSuppressed(throwable7);
                    throw throwable;
                }
            }
        }
        if (!success) return;
        this.syncLocal(remoteConfig);
    }

    protected Reader openConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0");
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        return new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
    }

    protected Configuration getLocalConfig(boolean ignoreFileNotFound) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedReader in = Files.newBufferedReader(Paths.get(this.local, new String[0]));){
                if (this.pk == null) {
                    return Configuration.read(in);
                }
                return Configuration.read((Reader)in, this.pk);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            if (!ignoreFileNotFound) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Configuration getRemoteConfig() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Reader in = this.openConnection(new URL(this.remote));){
                if (this.pk == null) {
                    return Configuration.read(in);
                }
                return Configuration.read(in, this.pk);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void syncLocal(Configuration remoteConfig) {
        Path localPath = Paths.get(this.local, new String[0]);
        try {
            if (localPath.getParent() != null) {
                Files.createDirectories(localPath.getParent(), new FileAttribute[0]);
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter out = Files.newBufferedWriter(localPath, new OpenOption[0]);){
                remoteConfig.write(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void welcome() {
        System.out.println(String.valueOf(DefaultBootstrap.getLogo()) + "\tWelcome to update4j, where you create your own auto-update lifecycle.\n\n" + "\tYou started its default bootstrap -- the built-in lifecycle -- which does\n" + "\tthe update and launch logic for you without complex setup. All you need is to\n" + "\tspecify some settings via command line arguments.\n\n" + "\tBefore you start, you first need to create a \"configuration\" file that contains\n" + "\tall details required to run. You can create one by using Configuration.builder()\n" + "\tBuilder API. For automation, you might use a build-tool plugin that executes\n" + "\tyour configuration generation on each build (Maven's exec-maven-plugin for one).\n\n" + "\tFor more details how to create a configuration please refer to the Javadoc:\n" + "\thttp://docs.update4j.org/javadoc/update4j/org.update4j/org/update4j/Configuration.html\n\n" + "\tWhile the default bootstrap works perfectly as an ad-hoc out-of-the-box setup, you might\n" + "\tfurther customize the update and launch lifecycle to the last detail by\n" + "\timplementing a custom bootstrap and update/launch your business application\n" + "\tusing the Configuration.update() and Configuration.launch() methods.\n\n" + "\tFor more details about implementing the bootstrap, please refer to the Github wiki:\n" + "\thttps://github.com/update4j/update4j/wiki/Documentation#lifecycle\n\n");
        DefaultBootstrap.usage();
    }

    private static String getLogo() {
        return "\n\t                 _       _          ___ _ \n\t                | |     | |        /   (_)\n\t _   _ _ __   __| | __ _| |_ ___  / /| |_ \n\t| | | | '_ \\ / _` |/ _` | __/ _ \\/ /_| | |\n\t| |_| | |_) | (_| | (_| | ||  __/\\___  | |\n\t \\__,_| .__/ \\__,_|\\__,_|\\__\\___|    |_/ |\n\t      | |                             _/ |\n\t      |_|                            |__/ \n\n\n";
    }

    private static void usage() {
        String output = "To start in modulepath:\n\n\tjava -p update4j-$version$.jar -m org.update4j [commands...] [-- business-args...]\n\tjava -p . -m org.update4j [commands...] [-- business-args...]\n\n\n\tWhen starting in the modulepath, be aware that as a fundamental restriction\n\tof the modulepath only the boot (JVM native) modulepath can resolve *system*\n\tmodules into the module graph. Therefore when the business application depends\n\ton a system module that is not required by the bootstrap application\n\tyou should still add a 'requires' directive in the bootstrap module in order\n\tto make it end up in the module graph.\n\n\tAlternatively, use the '--add-modules' flag to manually resolve those required\n\tsystem modules.\n\tIf you use the default bootstrap (and you don't have control to add more 'requires')\n\tyou must use this solution (or, of course, start in the classpath).\n\n\nTo start in classpath:\n\n\tjava -jar update4j-$version$.jar [commands...] [-- business-args...]\n\tjava -cp update4j-$version$.jar org.update4j.Bootstrap [commands...] [-- business-args...]\n\tjava -cp * org.update4j.Bootstrap [commands...] [-- business-args...]\n\n\n\tWhen starting in the classpath you can still leverage the full power of the Module\n\tSystem but only for the business application. If a file is marked with the \"modulepath\"\n\tattribute, the Module System will enforce all modularity rules for that individual module.\n\n\tUsing this combination of paths is a very simple way to circumvent the system module\n\trestriction explained in the previous section, i.e. it will automatically include all\n\tsystem modules into the runtime.\n\n\nAvailable commands:\n\n\t--remote [url] - The remote (or if using file:/// scheme - local) location of the\n\t\tconfiguration file. If it fails to download or command is missing, it will\n\t\tfall back to local.\n\n\t--local [path] - The path of a local configuration to use if the remote failed to download\n\t\tor was not passed. If both remote and local are missing, startup fails.\n\n\t--archive [path] - The archive location where to temporarily persist the downloaded files.\n\t\tIf not specified, the default value is './update.zip'.\n\n\t--syncLocal - Sync the local configuration with the remote if it downloaded, loaded and\n\t\tupdated files successfully. Useful to still allow launching without Internet connection.\n\t\tDefault will not sync unless --launchFirst was specified.\n\n\t--cert [path] - A path to an X.509 certificate file to use to verify signatures. If missing,\n\t\tno signature verification will be performed.\n\n\t--launchFirst - If specified, it will first launch the local application then silently\n\t\tdownload the update; the update will be available only on next restart. It will still\n\t\tdownload the remote and update first if the local config requires an update\n\t\t(e.g. files were deleted). Must have a local configuration.\n\t\tIf not specified it will update before launch and hang the application until done.\n\n\t--stopOnUpdateError - Will stop the launch if an error occurred while downloading an update.\n\t\tThis does not include if remote failed to download and it used local as a fallback.\n\t\tIf --launchFirst was used, this only applies if the local config requires an update\n\t\tand failed.\n\n\t--singleInstance - Run the application as a single instance. Any subsequent attempts\n\t\tto run will just exit. You can better control this feature by directly using the\n\t\tSingleInstanceManager class.\n\n\nTo pass arguments to the business application, separate them with '--' (w/o quotes).";
        System.err.println(output.replace("$version$", "1.5.9"));
    }
}

