/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.service;

import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Timer;
import java.util.TimerTask;
import org.update4j.FileMetadata;
import org.update4j.UpdateContext;
import org.update4j.service.UpdateHandler;
import org.update4j.util.FileUtils;
import org.update4j.util.StringUtils;

public class DefaultUpdateHandler
implements UpdateHandler {
    private UpdateContext context;
    private PrintStream out;
    private Timer timer;
    private int totalWidth;
    private int msgWidth;
    private int rateWidth;
    private int percentWidth;
    private int timeWidth;
    private String clear;
    private int ordinalWidth;
    private int total;
    private int index;
    private long totalBytes;
    private float lastFrac;
    private float currentFrac;
    private long start;
    private boolean stopTimer;

    @Override
    public long version() {
        return Long.MIN_VALUE;
    }

    @Override
    public void init(UpdateContext context) {
        this.context = context;
        this.out = this.out();
    }

    @Override
    public void startDownloads() throws Throwable {
        this.total = this.context.getRequiresUpdate().size();
        this.ordinalWidth = String.valueOf(this.total).length() * 2 + 1;
        this.initProgress();
    }

    @Override
    public void startDownloadFile(FileMetadata file) throws Throwable {
        ++this.index;
        this.println(this.renderFilename(file));
        this.resetProgress(file.getSize());
    }

    @Override
    public void updateDownloadFileProgress(FileMetadata file, float frac) throws Throwable {
        this.currentFrac = frac;
    }

    @Override
    public void doneDownloadFile(FileMetadata file, Path tempFile) throws Throwable {
        this.clear();
    }

    @Override
    public void failed(Throwable t) {
        this.clearln();
        t.printStackTrace(this.out);
    }

    @Override
    public void stop() {
        this.stopTimer = true;
    }

    @Override
    public UpdateContext getResult() {
        return this.context;
    }

    protected void initProgress() {
        this.totalWidth = this.consoleWidth();
        this.msgWidth = "Downloading".length();
        this.rateWidth = "@ 100.0 kB/s".length();
        this.percentWidth = "100%".length();
        this.timeWidth = "0:00:00".length();
        this.clear = "\r" + StringUtils.repeat(this.totalWidth, " ") + "\r";
        this.timer = new Timer("Progress Printer", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (DefaultUpdateHandler.this.stopTimer) {
                    DefaultUpdateHandler.this.timer.cancel();
                    return;
                }
                DefaultUpdateHandler.this.print(DefaultUpdateHandler.this.renderProgress());
                DefaultUpdateHandler.this.lastFrac = DefaultUpdateHandler.this.currentFrac;
            }
        }, 0L, 1000L);
    }

    protected void resetProgress(long bytes) {
        this.currentFrac = 0.0f;
        this.lastFrac = 0.0f;
        this.totalBytes = bytes;
        this.start = System.currentTimeMillis();
    }

    protected PrintStream out() {
        return System.out;
    }

    protected int consoleWidth() {
        return 80;
    }

    private void clear() {
        this.out.print(this.clear);
    }

    private void clearln() {
        this.out.println(this.clear);
    }

    private void print(String str) {
        this.out.print("\r");
        this.out.print(StringUtils.padRight(this.totalWidth, str));
    }

    private void println(String str) {
        this.out.print("\r");
        this.out.println(StringUtils.padRight(this.totalWidth, str));
    }

    protected String renderProgress() {
        StringBuilder sb = new StringBuilder();
        sb.append("Downloading ");
        String humanReadableBytes = StringUtils.humanReadableByteCount(this.totalBytes);
        sb.append(humanReadableBytes);
        sb.append(" ");
        if (this.lastFrac == 0.0f && this.currentFrac == 0.0f) {
            sb.append(StringUtils.repeat(this.rateWidth + 1, " "));
        } else {
            sb.append("@ ");
            sb.append(StringUtils.padRight(this.rateWidth - 2, String.valueOf(StringUtils.humanReadableByteCount((long)((this.currentFrac - this.lastFrac) * (float)this.totalBytes))) + "/s"));
            sb.append(" ");
        }
        sb.append(StringUtils.padLeft(this.percentWidth, String.valueOf((int)(this.currentFrac * 100.0f)) + "%"));
        sb.append(" [");
        int progressWidth = this.totalWidth - this.msgWidth - humanReadableBytes.length() - this.rateWidth - this.percentWidth - this.timeWidth - 7;
        int pieces = (int)((float)(progressWidth - 2) * this.currentFrac);
        String line = StringUtils.repeat(pieces, "=");
        if (pieces < progressWidth - 2) {
            line = String.valueOf(line) + ">";
        }
        sb.append(StringUtils.padRight(progressWidth - 2, line));
        sb.append("]");
        long elapsed = System.currentTimeMillis() - this.start;
        if (this.currentFrac > 0.0f) {
            sb.append(" (");
            sb.append(StringUtils.formatSeconds(((long)((float)elapsed / this.currentFrac) - elapsed) / 1000L));
            sb.append(")");
        }
        return sb.toString();
    }

    protected String renderFilename(FileMetadata file) {
        return String.valueOf(StringUtils.padLeft(this.ordinalWidth, String.valueOf(this.index) + "/" + this.total)) + " " + this.compactName(file.getPath());
    }

    private String compactName(Path name) {
        Path relative = FileUtils.relativize(this.context.getConfiguration().getBasePath(), name);
        return relative.isAbsolute() ? relative.getFileName().toString() : relative.toString();
    }
}

