/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.service;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.update4j.inject.Injectable;
import org.update4j.util.StringUtils;

public interface Service
extends Injectable {
    default public long version() {
        return 0L;
    }

    public static <T extends Service> T loadService(ModuleLayer layer, ClassLoader classLoader, Class<T> type, String classname) {
        ServiceLoader<T> loader;
        if (classname != null && !StringUtils.isClassName(classname)) {
            throw new IllegalArgumentException(String.valueOf(classname) + " is not a valid Java class name.");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ArrayList providers = new ArrayList();
        if (layer != null) {
            loader = ServiceLoader.load(layer, type);
            providers.addAll(loader.stream().collect(Collectors.toList()));
        }
        loader = ServiceLoader.load(type, classLoader);
        providers.addAll(loader.stream().collect(Collectors.toList()));
        if (classname != null) {
            for (ServiceLoader.Provider p : providers) {
                if (!p.type().getName().equals(classname)) continue;
                return (T)((Service)p.get());
            }
            try {
                Class<?> clazz = classLoader.loadClass(classname);
                if (type.isAssignableFrom(clazz)) {
                    Service value = (Service)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    return (T)value;
                }
                throw new IllegalArgumentException(String.valueOf(classname) + " is not of type " + type.getCanonicalName());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (providers.isEmpty()) {
            throw new IllegalStateException("No provider found for " + type.getCanonicalName());
        }
        List values = providers.stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        long maxVersion = Long.MIN_VALUE;
        Service maxValue = null;
        for (Service t : values) {
            long version = t.version();
            if (maxVersion > version) continue;
            maxVersion = version;
            maxValue = t;
        }
        return (T)maxValue;
    }

    public static <T extends Service> T loadService(ModuleLayer layer, ClassLoader classLoader, Class<T> type) {
        return Service.loadService(layer, classLoader, type, null);
    }

    public static <T extends Service> T loadService(ModuleLayer layer, Class<T> type, String classname) {
        return Service.loadService(layer, null, type, classname);
    }

    public static <T extends Service> T loadService(ModuleLayer layer, Class<T> type) {
        return Service.loadService(layer, null, type, null);
    }

    public static <T extends Service> T loadService(ClassLoader classLoader, Class<T> type, String classname) {
        return Service.loadService(null, classLoader, type, classname);
    }

    public static <T extends Service> T loadService(ClassLoader classLoader, Class<T> type) {
        return Service.loadService(null, classLoader, type, null);
    }

    public static <T extends Service> T loadService(Class<T> type, String classname) {
        return Service.loadService(null, null, type, classname);
    }

    public static <T extends Service> T loadService(Class<T> type) {
        return Service.loadService(type, null);
    }
}

