/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.service;

import java.io.InputStream;
import java.net.URLConnection;
import java.nio.file.Path;
import org.update4j.FileMetadata;
import org.update4j.UpdateContext;
import org.update4j.service.Service;

public interface UpdateHandler
extends Service {
    default public void init(UpdateContext context) throws Throwable {
    }

    default public void startCheckUpdates() throws Throwable {
    }

    default public boolean shouldCheckForUpdate(FileMetadata file) {
        return true;
    }

    default public void startCheckUpdateFile(FileMetadata file) throws Throwable {
    }

    default public void doneCheckUpdateFile(FileMetadata file, boolean requires) throws Throwable {
    }

    default public void updateCheckUpdatesProgress(float frac) throws Throwable {
    }

    default public void doneCheckUpdates() throws Throwable {
    }

    default public void startDownloads() throws Throwable {
    }

    default public InputStream openDownloadStream(FileMetadata file) throws Throwable {
        URLConnection connection = file.getUri().toURL().openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0");
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        return connection.getInputStream();
    }

    default public void startDownloadFile(FileMetadata file) throws Throwable {
    }

    default public void updateDownloadFileProgress(FileMetadata file, float frac) throws Throwable {
    }

    default public void updateDownloadProgress(float frac) throws Throwable {
    }

    default public void validatingFile(FileMetadata file, Path path) throws Throwable {
    }

    default public void doneDownloadFile(FileMetadata file, Path path) throws Throwable {
    }

    default public void doneDownloads() throws Throwable {
    }

    default public void failed(Throwable t) {
    }

    default public void succeeded() {
    }

    default public void stop() {
    }

    default public Object getResult() {
        return null;
    }
}

