/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArgUtils {
    private ArgUtils() {
    }

    public static Map<String, String> parseArgs(List<String> list) {
        Pattern pattern = Pattern.compile("--(.+?)(?:\\s*=\\s*|\\s+)(.+)");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < list.size()) {
            String arg = list.get(i).trim();
            if (arg.startsWith("--")) {
                Matcher m = pattern.matcher(arg);
                if (m.find()) {
                    String key = m.group(1);
                    if (map.containsKey(key)) {
                        throw new IllegalArgumentException("Duplicate command '" + key + "'.");
                    }
                    map.put(key, m.group(2));
                } else {
                    String value;
                    if (map.containsKey(arg = arg.substring(2))) {
                        throw new IllegalArgumentException("Duplicate command '" + arg + "'.");
                    }
                    if (i + 1 < list.size() && !(value = list.get(i + 1).trim()).startsWith("--")) {
                        map.put(arg, value);
                        ++i;
                    } else {
                        map.put(arg, null);
                    }
                }
            } else {
                throw new IllegalArgumentException("Unknown command '" + arg + "'.");
            }
            ++i;
        }
        return map;
    }

    public static List<String> beforeSeparator(List<String> args) {
        int separatorIdx = args.indexOf("--");
        if (separatorIdx < 0) {
            return args;
        }
        return args.subList(0, separatorIdx);
    }

    public static List<String> afterSeparator(List<String> args) {
        int separatorIdx = args.indexOf("--");
        if (separatorIdx < 0) {
            return List.of();
        }
        return args.subList(separatorIdx + 1, args.size());
    }

    public static void validateNoValue(Map.Entry<String, String> e) {
        if (e.getValue() != null) {
            throw new IllegalArgumentException("Unknown command '" + e.getValue() + "'.");
        }
    }

    public static void validateHasValue(Map.Entry<String, String> e) {
        if (e.getValue() == null) {
            throw new IllegalArgumentException("Missing value for '--" + e.getKey() + "'.");
        }
    }
}

