/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.util;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.Adler32;
import java.util.zip.ZipFile;
import org.update4j.OS;

public class FileUtils {
    public static final Pattern OS_PATTERN = Pattern.compile(".+-(linux|win|mac)\\.[^.]+");

    private FileUtils() {
    }

    public static long getChecksum(Path path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            int read;
            Adler32 checksum = new Adler32();
            byte[] buf = new byte[8192];
            while ((read = input.read(buf, 0, buf.length)) > -1) {
                checksum.update(buf, 0, read);
            }
            return checksum.getValue();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getChecksumString(Path path) throws IOException {
        return Long.toHexString(FileUtils.getChecksum(path));
    }

    public static boolean isJarFile(Path path) throws IOException {
        if (!FileUtils.isZipFile(path)) {
            return false;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (ZipFile zip = new ZipFile(path.toFile());){
            boolean bl = zip.getEntry("META-INF/MANIFEST.MF") != null;
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isZipFile(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        if (!Files.isReadable(path)) {
            throw new IOException("Cannot read file " + path.toAbsolutePath());
        }
        if (Files.size(path) < 4L) {
            return false;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (DataInputStream in = new DataInputStream(Files.newInputStream(path, new OpenOption[0]));){
            int test = in.readInt();
            boolean bl = test == 1347093252;
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] sign(Path path, PrivateKey key) throws IOException {
        try {
            Signature sign = FileUtils.getSignature(key);
            sign.initSign(key);
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
                int len;
                byte[] buf = new byte[8192];
                while ((len = input.read(buf, 0, buf.length)) > 0) {
                    sign.update(buf, 0, len);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return sign.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new IOException(e);
        }
    }

    public static String signAndEncode(Path path, PrivateKey key) throws IOException {
        return Base64.getEncoder().encodeToString(FileUtils.sign(path, key));
    }

    public static Signature getSignature(Key key) {
        String alg = key.getAlgorithm().equals("EC") ? "ECDSA" : key.getAlgorithm();
        try {
            return Signature.getInstance("SHA256with" + alg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Path fromUri(URI uri) {
        String path = uri.getPath();
        if (uri.isAbsolute()) {
            path = path.substring(path.lastIndexOf("/") + 1);
        }
        return Paths.get(path, new String[0]);
    }

    public static URI fromPath(Path path) {
        if (path.isAbsolute()) {
            Path filename = path.getFileName();
            return FileUtils.fromPath(filename);
        }
        try {
            String uri = URLEncoder.encode(path.toString().replace("\\", "/"), "UTF-8");
            uri = uri.replace("%2F", "/").replace("+", "%20");
            return URI.create(uri);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static URI relativize(URI base, URI other) {
        if (base == null || other == null) {
            return other;
        }
        return base.relativize(other);
    }

    public static Path relativize(Path base, Path other) {
        if (base == null || other == null) {
            return other;
        }
        try {
            return base.relativize(other);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return other;
        }
    }

    public static Path resolve(Path base, Path child) {
        return base.resolve(child.toString().replaceFirst("^\\\\|/", ""));
    }

    public static OS fromFilename(String filename) {
        Matcher osMatcher = OS_PATTERN.matcher(filename);
        if (osMatcher.matches()) {
            return OS.fromShortName(osMatcher.group(1));
        }
        return null;
    }

    public static boolean isEmptyDirectory(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (DirectoryStream<Path> dir = Files.newDirectoryStream(path);){
                boolean bl = !dir.iterator().hasNext();
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return false;
    }

    public static void windowsHidden(Path file, boolean hidden) {
        if (OS.CURRENT != OS.WINDOWS) {
            return;
        }
        try {
            Files.setAttribute(file, "dos:hidden", hidden, new LinkOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void verifyAccessible(Path path) throws IOException {
        boolean exists = Files.exists(path, new LinkOption[0]);
        if (exists && !Files.isWritable(path)) {
            throw new AccessDeniedException(path.toString());
        }
        if (path.getParent() != null) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try {
            Throwable throwable = null;
            Object var3_3 = null;
            try {
                BufferedWriter out = Files.newBufferedWriter(path, exists ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
                if (out != null) {
                    ((Writer)out).close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (!exists) {
                Files.deleteIfExists(path);
            }
        }
    }

    public static void secureMoveFile(Path source, Path target) throws IOException {
        if (OS.CURRENT == OS.WINDOWS || Files.notExists(target, new LinkOption[0])) {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        Path temp = Files.createTempFile(target.getParent(), null, null, new FileAttribute[0]);
        Files.move(target, temp, StandardCopyOption.REPLACE_EXISTING);
        try {
            try {
                Files.move(source, target, new CopyOption[0]);
            }
            catch (IOException e) {
                Files.move(temp, target, new CopyOption[0]);
                throw e;
            }
        }
        finally {
            Files.deleteIfExists(temp);
        }
    }

    public static void delayedDelete(Collection<Path> files, int secondsDelay) {
        secondsDelay = Math.max(secondsDelay, 1);
        ArrayList<String> commands = new ArrayList<String>();
        String filenames = files.stream().map(Path::toString).map(f -> "\"" + f.replace("\"", "\\\"") + "\"").collect(Collectors.joining(" "));
        if (OS.CURRENT == OS.WINDOWS) {
            commands.addAll(List.of("cmd", "/c"));
            commands.add("ping localhost -n " + (secondsDelay + 1) + " & del " + filenames);
        } else {
            commands.addAll(List.of("sh", "-c"));
            commands.add("sleep " + secondsDelay + " ; rm " + filenames);
        }
        ProcessBuilder pb = new ProcessBuilder(commands);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                pb.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
    }
}

