/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.module.FindException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.update4j.util.StringUtils;
import org.update4j.util.Warning;

public class ModuleUtils {
    private static final String SERVICES_PREFIX = "META-INF/services/";
    private static final Attributes.Name AUTOMATIC_MODULE_NAME = new Attributes.Name("Automatic-Module-Name");

    public static Set<Module> userBootModules() {
        Set sysmods = ModuleFinder.ofSystem().findAll().stream().map(ModuleReference::descriptor).map(ModuleDescriptor::name).collect(Collectors.toSet());
        return ModuleLayer.boot().modules().stream().filter(mod -> !sysmods.contains(mod.getName())).collect(Collectors.toSet());
    }

    /*
     * Loose catch block
     */
    public static ModuleDescriptor deriveModuleDescriptor(Path jar, String filename, boolean readZip) throws IOException {
        if (!readZip) {
            return ModuleUtils.primitiveModuleDescriptor(jar, filename);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileSystem zip = FileSystems.newFileSystem(jar, ClassLoader.getSystemClassLoader());){
            Path moduleInfo = zip.getPath("/module-info.class", new String[0]);
            if (Files.exists(moduleInfo, new LinkOption[0])) {
                ModuleDescriptor moduleDescriptor;
                InputStream in;
                Throwable throwable2;
                block21: {
                    throwable2 = null;
                    Object var8_11 = null;
                    in = Files.newInputStream(moduleInfo, new OpenOption[0]);
                    moduleDescriptor = ModuleDescriptor.read(in, () -> {
                        try {
                            Path root = zip.getPath("/", new String[0]);
                            return Files.walk(root, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0])).map(f -> root.relativize((Path)f)).map(Path::toString).map(ModuleUtils::toPackageName).flatMap(Optional::stream).collect(Collectors.toSet());
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                    if (in == null) break block21;
                    in.close();
                }
                return moduleDescriptor;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            return ModuleUtils.automaticModule(zip, filename);
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private static ModuleDescriptor primitiveModuleDescriptor(Path jar, String filename) throws IOException {
        ModuleDescriptor mod;
        String tempName = "a" + jar.getFileName();
        Path temp = Paths.get(System.getProperty("user.home"), String.valueOf(tempName) + ".jar");
        try {
            Files.copy(jar, temp, new CopyOption[0]);
            mod = ModuleFinder.of(temp).findAll().stream().map(ModuleReference::descriptor).findAny().orElseThrow(IllegalStateException::new);
        }
        finally {
            Files.deleteIfExists(temp);
        }
        if (tempName.equals(mod.name())) {
            String newModuleName = StringUtils.deriveModuleName(filename);
            if (!StringUtils.isModuleName(newModuleName)) {
                Warning.illegalModule(jar.getFileName().toString());
                throw new IllegalStateException("Automatic module name '" + newModuleName + "' for file '" + jar.getFileName() + "' is not valid.");
            }
            return ModuleDescriptor.newAutomaticModule(newModuleName).packages(mod.packages()).build();
        }
        return mod;
    }

    private static ModuleDescriptor automaticModule(FileSystem zip, String filename) throws IOException {
        ModuleDescriptor.Builder builder;
        Manifest man = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = Files.newInputStream(zip.getPath("/META-INF/MANIFEST.MF", new String[0]), new OpenOption[0]);){
            man = new Manifest(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Attributes attrs = null;
        String moduleName = null;
        if (man != null && (attrs = man.getMainAttributes()) != null) {
            moduleName = attrs.getValue(AUTOMATIC_MODULE_NAME);
        }
        if (moduleName != null) {
            try {
                builder = ModuleDescriptor.newAutomaticModule(moduleName);
            }
            catch (IllegalArgumentException e2) {
                throw new FindException(AUTOMATIC_MODULE_NAME + ": " + e2.getMessage());
            }
        } else {
            builder = ModuleDescriptor.newAutomaticModule(StringUtils.deriveModuleName(filename));
        }
        Map map = Files.walk(zip.getPath("/", new String[0]), new FileVisitOption[0]).filter(e -> !Files.isDirectory(e, new LinkOption[0])).map(Path::toString).filter(e -> e.endsWith(".class") ^ e.startsWith(SERVICES_PREFIX)).collect(Collectors.partitioningBy(e -> e.startsWith(SERVICES_PREFIX), Collectors.toSet()));
        Set classFiles = map.get(Boolean.FALSE);
        Set configFiles = map.get(Boolean.TRUE);
        Set<String> packages = classFiles.stream().map(ModuleUtils::toPackageName).flatMap(Optional::stream).distinct().collect(Collectors.toSet());
        builder.packages(packages);
        Set serviceNames = configFiles.stream().map(ModuleUtils::toServiceName).flatMap(Optional::stream).collect(Collectors.toSet());
        for (String sn : serviceNames) {
            Path entry = zip.getPath(SERVICES_PREFIX + sn, new String[0]);
            ArrayList<String> providerClasses = new ArrayList<String>();
            Throwable throwable3 = null;
            Object var16_20 = null;
            try (InputStream in = Files.newInputStream(entry, new OpenOption[0]);){
                String cn;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                while ((cn = ModuleUtils.nextLine(reader)) != null) {
                    if (cn.isEmpty()) continue;
                    String pn = ModuleUtils.packageName(cn);
                    if (!packages.contains(pn)) {
                        String msg = "Provider class " + cn + " not in module";
                        throw new InvalidModuleDescriptorException(msg);
                    }
                    providerClasses.add(cn);
                }
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            if (providerClasses.isEmpty()) continue;
            builder.provides(sn, providerClasses);
        }
        return builder.build();
    }

    private static String nextLine(BufferedReader reader) throws IOException {
        String ln = reader.readLine();
        if (ln != null) {
            int ci = ln.indexOf(35);
            if (ci >= 0) {
                ln = ln.substring(0, ci);
            }
            ln = ln.trim();
        }
        return ln;
    }

    private static String packageName(String cn) {
        int index = cn.lastIndexOf(46);
        return index == -1 ? "" : cn.substring(0, index);
    }

    private static Optional<String> toPackageName(String name) {
        int index = name.lastIndexOf("/");
        if (index == -1) {
            if (name.endsWith(".class") && !name.equals("module-info.class")) {
                String msg = String.valueOf(name) + " found in top-level directory" + " (unnamed package not allowed in module)";
                throw new InvalidModuleDescriptorException(msg);
            }
            return Optional.empty();
        }
        String pn = name.substring(0, index).replace('/', '.');
        if (StringUtils.isClassName(pn)) {
            return Optional.of(pn);
        }
        return Optional.empty();
    }

    private static Optional<String> toServiceName(String cf) {
        String sn;
        String prefix;
        int index = cf.lastIndexOf("/") + 1;
        if (index < cf.length() && (prefix = cf.substring(0, index)).equals(SERVICES_PREFIX) && StringUtils.isClassName(sn = cf.substring(index))) {
            return Optional.of(sn);
        }
        return Optional.empty();
    }
}

