/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.update4j.OS;
import org.update4j.PlaceholderMatchType;
import org.update4j.Property;

public class PropertyManager {
    public static final Pattern PLACEHOLDER = Pattern.compile("\\$\\{([^}]+)\\}");
    private List<Property> unmodifiableProperties;
    private Map<String, String> unmodifiableDynamicProperties;
    private Map<String, String> resolvedProperties;
    private Map<String, String> unmodifiableResolvedProperties;

    public PropertyManager(List<Property> properties, Map<String, String> dynamicProperties, List<String> systemProperties) {
        int j;
        this.unmodifiableProperties = Collections.unmodifiableList(properties != null ? properties : List.of());
        this.unmodifiableDynamicProperties = Collections.unmodifiableMap(dynamicProperties != null ? dynamicProperties : Map.of());
        int i = 1;
        while (i < this.unmodifiableProperties.size()) {
            j = 0;
            while (j < i) {
                Property ip = properties.get(i);
                Property jp = properties.get(j);
                if (ip.getKey().equals(jp.getKey()) && ip.getOs() == jp.getOs()) {
                    throw new IllegalArgumentException("Duplicate property: " + ip.getKey());
                }
                ++j;
            }
            ++i;
        }
        if (systemProperties != null) {
            i = 1;
            while (i < systemProperties.size()) {
                j = 0;
                while (j < i) {
                    if (systemProperties.get(i).equals(systemProperties.get(j))) {
                        throw new IllegalArgumentException("Duplicate system property: " + systemProperties.get(i));
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.resolvedProperties = PropertyManager.extractPropertiesForCurrentMachine(this.unmodifiableProperties, systemProperties);
        if (dynamicProperties != null) {
            this.resolvedProperties.putAll(dynamicProperties);
        }
        this.resolvedProperties = PropertyManager.resolveDependencies(this.resolvedProperties);
        this.unmodifiableResolvedProperties = Collections.unmodifiableMap(this.resolvedProperties);
    }

    public List<Property> getProperties() {
        return this.unmodifiableProperties;
    }

    public List<Property> getProperties(String key) {
        return this.getProperties().stream().filter(p -> p.getKey().equals(key)).collect(Collectors.toList());
    }

    public Map<String, String> getResolvedProperties() {
        return this.unmodifiableResolvedProperties;
    }

    public String getResolvedProperty(String key) {
        return this.resolvedProperties.get(key);
    }

    public Map<String, String> getDynamicProperties() {
        return this.unmodifiableDynamicProperties;
    }

    public String resolvePlaceholders(String str) {
        return this.resolvePlaceholders(str, false);
    }

    public String resolvePlaceholders(String str, boolean isPath) {
        return this.resolvePlaceholders(str, isPath, false);
    }

    public String resolvePlaceholders(String str, boolean isPath, boolean ignoreForeignProperty) {
        if (str == null) {
            return null;
        }
        Matcher match = PLACEHOLDER.matcher(str);
        while (match.find()) {
            String key = match.group(1);
            String value = this.resolvedProperties.get(key);
            if (value == null) {
                Property prop = this.getProperties(key).stream().findAny().orElse(null);
                if (prop != null && prop.getOs() != null && prop.getOs() != OS.CURRENT && ignoreForeignProperty) continue;
                value = PropertyManager.trySystemProperty(key);
                this.resolvedProperties.put(key, value);
            }
            str = str.replace(PropertyManager.wrap(key), value);
        }
        if (isPath) {
            str = str.replace("\\", "/");
        }
        return str;
    }

    public String implyPlaceholders(String str) {
        return this.implyPlaceholders(str, false);
    }

    public String implyPlaceholders(String str, boolean isPath) {
        return this.implyPlaceholders(str, PlaceholderMatchType.WHOLE_WORD, isPath);
    }

    public String implyPlaceholders(String str, PlaceholderMatchType matchType) {
        return this.implyPlaceholders(str, matchType, false);
    }

    public String implyPlaceholders(String str, PlaceholderMatchType matchType, boolean isPath) {
        if (str == null) {
            return null;
        }
        Objects.requireNonNull(matchType);
        if (isPath) {
            str = str.replace("\\", "/");
        }
        if (matchType == PlaceholderMatchType.NONE) {
            return str;
        }
        List resolved = this.resolvedProperties.entrySet().stream().filter(e -> !((String)e.getValue()).isEmpty()).sorted((e1, e2) -> ((String)e2.getValue()).length() - ((String)e1.getValue()).length()).peek(e -> PropertyManager.normalizePath(e, isPath)).collect(Collectors.toList());
        for (Map.Entry e3 : resolved) {
            if (!str.equals(e3.getValue())) continue;
            return PropertyManager.wrap((String)e3.getKey());
        }
        if (matchType == PlaceholderMatchType.FULL_MATCH) {
            return str;
        }
        if (matchType == PlaceholderMatchType.EVERY_OCCURRENCE || matchType == PlaceholderMatchType.WHOLE_WORD) {
            for (Map.Entry e3 : resolved) {
                String key = (String)e3.getKey();
                String wrappedKey = Matcher.quoteReplacement(PropertyManager.wrap(key));
                String quote = Pattern.quote((String)e3.getValue());
                if (isPath && (key.equals("user.home") || key.equals("user.dir"))) {
                    if (str.contains(PropertyManager.wrap(key))) continue;
                    if (matchType == PlaceholderMatchType.WHOLE_WORD) {
                        quote = String.valueOf(quote) + "\\b";
                    }
                    str = str.replaceFirst("^(file:/*)?" + quote, "$1" + wrappedKey);
                    continue;
                }
                if (matchType == PlaceholderMatchType.WHOLE_WORD) {
                    quote = "\\b" + quote + "\\b";
                }
                String pattern = "(\\$\\{[^{}]*)|" + quote;
                Matcher m = Pattern.compile(pattern).matcher(str);
                str = m.replaceAll(i -> i.group(1) != null ? Matcher.quoteReplacement(i.group(1)) : wrappedKey);
            }
            return str;
        }
        throw new UnsupportedOperationException("Unknown " + PlaceholderMatchType.class.getSimpleName());
    }

    private static void normalizePath(Map.Entry<String, String> e, boolean isPath) {
        if (isPath) {
            e.setValue(e.getValue().replace("\\", "/"));
        }
    }

    private static Map<String, String> extractPropertiesForCurrentMachine(Collection<? extends Property> properties, Collection<String> systemProperties) {
        HashMap<String, String> resolved = new HashMap<String, String>();
        if (systemProperties != null) {
            for (String string : systemProperties) {
                resolved.put(string, PropertyManager.trySystemProperty(string, true));
            }
        }
        if (properties != null) {
            for (Property property : properties) {
                if (property.getOs() != null) continue;
                resolved.put(property.getKey(), property.getValue());
            }
            for (Property property : properties) {
                if (property.getOs() != OS.CURRENT) continue;
                resolved.put(property.getKey(), property.getValue());
            }
        }
        return resolved;
    }

    private static Map<String, String> resolveDependencies(Map<String, String> properties) {
        HashMap<String, String> noDeps = new HashMap<String, String>();
        while (properties.size() > 0) {
            int noDepsSize = noDeps.size();
            ArrayList<Map.Entry<String, String>> found = new ArrayList<Map.Entry<String, String>>();
            Iterator<Map.Entry<String, String>> iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                if (PLACEHOLDER.matcher(entry.getValue()).find()) continue;
                iter.remove();
                found.add(entry);
                noDeps.put(entry.getKey(), entry.getValue());
            }
            if (noDepsSize == noDeps.size()) {
                boolean foundSystem = false;
                String key = null;
                for (String string : properties.values()) {
                    Matcher match = PLACEHOLDER.matcher(string);
                    match.find();
                    key = match.group(1);
                    if (properties.containsKey(key)) continue;
                    String sys = PropertyManager.trySystemProperty(key);
                    noDeps.put(key, sys);
                    found.add(Map.entry(key, sys));
                    foundSystem = true;
                }
                if (!foundSystem) {
                    throw new IllegalStateException("Cyclic property detected: " + key);
                }
            }
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                for (Map.Entry entry2 : found) {
                    entry.setValue(entry.getValue().replace(PropertyManager.wrap((String)entry2.getKey()), (CharSequence)entry2.getValue()));
                }
            }
        }
        return noDeps;
    }

    private static String trySystemProperty(String key, boolean systemInError) {
        String value = System.getProperty(key, System.getenv(key));
        if (value != null) {
            if (PLACEHOLDER.matcher(value).find()) {
                throw new IllegalStateException("System properties must not contain placeholders.");
            }
            return value;
        }
        throw new IllegalArgumentException("Could not resolve " + (systemInError ? "system " : "") + "property '" + key + "'");
    }

    private static String trySystemProperty(String key) {
        return PropertyManager.trySystemProperty(key, false);
    }

    public static String wrap(String key) {
        return "${" + key + "}";
    }

    public static boolean containsPlaceholder(String str) {
        return PLACEHOLDER.matcher(str).find();
    }
}

