/*
 * Decompiled with CFR 0.152.
 */
package org.update4j.util;

import java.lang.reflect.Method;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.Set;

public class StringUtils {
    public static final String CLASS_REGEX = "([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*";
    private static final Set<String> keywords = Set.of("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");
    private static final Set<String> moduleKeywords = Set.of("module", "open", "opens", "exports", "requires", "transitive", "to", "with", "provides", "uses");
    private static final Set<String> systemModules = Set.of("java.rmi", "jdk.management.jfr", "jdk.jdi", "jdk.charsets", "jdk.pack", "java.xml", "jdk.xml.dom", "jdk.rmic", "java.datatransfer", "jdk.jstatd", "jdk.httpserver", "jdk.jcmd", "java.desktop", "java.se", "java.security.sasl", "jdk.zipfs", "java.base", "jdk.crypto.ec", "jdk.javadoc", "jdk.management.agent", "jdk.jshell", "jdk.editpad", "java.sql.rowset", "jdk.sctp", "jdk.jsobject", "jdk.unsupported", "jdk.jlink", "java.smartcardio", "jdk.scripting.nashorn", "jdk.scripting.nashorn.shell", "java.security.jgss", "java.compiler", "jdk.dynalink", "jdk.unsupported.desktop", "jdk.accessibility", "jdk.security.jgss", "java.sql", "jdk.hotspot.agent", "java.transaction.xa", "java.xml.crypto", "java.logging", "jdk.jfr", "jdk.internal.vm.ci", "jdk.crypto.cryptoki", "jdk.net", "java.naming", "jdk.internal.ed", "java.prefs", "java.net.http", "jdk.compiler", "jdk.naming.rmi", "jdk.internal.opt", "jdk.jconsole", "jdk.attach", "jdk.crypto.mscapi", "jdk.internal.le", "java.management", "jdk.jdwp.agent", "jdk.internal.jvmstat", "java.instrument", "jdk.internal.vm.compiler", "jdk.internal.vm.compiler.management", "jdk.management", "jdk.security.auth", "java.scripting", "jdk.jdeps", "jdk.aot", "jdk.jartool", "java.management.rmi", "jdk.naming.dns", "jdk.localedata");

    private StringUtils() {
    }

    public static boolean isClassName(String name) {
        String[] tokens;
        if (!name.matches(CLASS_REGEX)) {
            return false;
        }
        String[] stringArray = tokens = name.split("\\.");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (keywords.contains(t)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isModuleName(String name) {
        String[] tokens;
        if (!StringUtils.isClassName(name)) {
            return false;
        }
        String[] stringArray = tokens = name.split("\\.");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (moduleKeywords.contains(t)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String deriveModuleName(String filename) {
        filename = filename.replaceAll("\\.jar$", "");
        filename = filename.replaceAll("-\\d.*", "");
        filename = filename.replaceAll("[^A-Za-z0-9]", ".");
        filename = filename.replaceAll("^\\.*|\\.*$", "");
        filename = filename.replaceAll("\\.{2,}", ".");
        return filename;
    }

    public static boolean isSystemModule(String str) {
        return systemModules.contains(str);
    }

    public static String repeat(int n, String str) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0: " + n);
        }
        try {
            Method repeat = String.class.getMethod("repeat", Integer.TYPE);
            return (String)repeat.invoke((Object)str, n);
        }
        catch (ReflectiveOperationException e) {
            return String.join((CharSequence)"", Collections.nCopies(n, str));
        }
    }

    public static String padLeft(int width, String str) {
        if (str.length() >= width) {
            return str;
        }
        return String.valueOf(StringUtils.repeat(width - str.length(), " ")) + str;
    }

    public static String padRight(int width, String str) {
        if (str.length() >= width) {
            return str;
        }
        return String.valueOf(str) + StringUtils.repeat(width - str.length(), " ");
    }

    public static String formatSeconds(long m) {
        return String.format("%d:%02d:%02d", m / 3600L, m % 3600L / 60L, m % 60L);
    }

    public static String humanReadableByteCount(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return String.valueOf(bytes) + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }
}

